/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk.pll;

import io.github.dsheirer.dsp.psk.pll.IFrequencyErrorProcessor;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.dsp.psk.pll.PLLBandwidth;
import io.github.dsheirer.sample.complex.Complex;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostasLoop
implements IPhaseLockedLoop {
    private static final Logger mLog = LoggerFactory.getLogger(CostasLoop.class);
    public static final double TWO_PI = Math.PI * 2;
    private Complex mCurrentVector = new Complex(0.0f, 0.0f);
    private double mLoopPhase = 0.0;
    private double mLoopFrequency = 0.0;
    private double mMaximumLoopFrequency;
    private double mDamping = FastMath.sqrt((double)2.0) / 2.0;
    private double mAlphaGain;
    private double mBetaGain;
    private PLLBandwidth mPLLBandwidth = PLLBandwidth.BW_400;
    private double mSymbolRate;
    private double mSampleRate;
    private IFrequencyErrorProcessor mFrequencyErrorProcessor;
    private long mFrequencyError;
    private int mBaudCounter;

    public CostasLoop(double sampleRate, double symbolRate) {
        this.mSymbolRate = symbolRate;
        this.mSampleRate = sampleRate;
        this.mMaximumLoopFrequency = Math.PI * 2 * (symbolRate / 2.0) / sampleRate;
        this.updateLoopBandwidth();
    }

    public void setFrequencyErrorProcessor(IFrequencyErrorProcessor listener) {
        this.mFrequencyErrorProcessor = listener;
    }

    @Override
    public void correctInversion(double correction) {
        this.mLoopFrequency += correction;
        while (this.mLoopFrequency > this.mMaximumLoopFrequency) {
            this.mLoopFrequency -= 2.0 * this.mMaximumLoopFrequency;
        }
        while (this.mLoopFrequency < -this.mMaximumLoopFrequency) {
            this.mLoopFrequency += 2.0 * this.mMaximumLoopFrequency;
        }
    }

    private void updateLoopBandwidth() {
        double bandwidth = Math.PI * 2 / this.mPLLBandwidth.getLoopBandwidth();
        this.mAlphaGain = 4.0 * this.mDamping * bandwidth / (1.0 + 2.0 * this.mDamping * bandwidth + bandwidth * bandwidth);
        this.mBetaGain = 4.0 * bandwidth * bandwidth / (1.0 + 2.0 * this.mDamping * bandwidth + bandwidth * bandwidth);
    }

    public void setPLLBandwidth(PLLBandwidth pllBandwidth) {
        if (this.mPLLBandwidth != pllBandwidth) {
            this.mPLLBandwidth = pllBandwidth;
            this.updateLoopBandwidth();
        }
    }

    @Override
    public void increment() {
        this.mLoopPhase += this.mLoopFrequency;
        if (this.mLoopPhase > Math.PI * 2) {
            this.mLoopPhase -= Math.PI * 2;
        }
        if (this.mLoopPhase < Math.PI * -2) {
            this.mLoopPhase += Math.PI * 2;
        }
    }

    @Override
    public Complex getCurrentVector() {
        this.mCurrentVector.setAngle(this.mLoopPhase);
        return this.mCurrentVector;
    }

    @Override
    public Complex incrementAndGetCurrentVector() {
        this.increment();
        return this.getCurrentVector();
    }

    public double getLoopFrequency() {
        return this.mLoopFrequency;
    }

    @Override
    public void adjust(double phaseError) {
        this.mLoopFrequency += this.mBetaGain * phaseError;
        this.mLoopPhase += this.mLoopFrequency + this.mAlphaGain * phaseError;
        if (this.mLoopPhase > Math.PI * 2) {
            this.mLoopPhase -= Math.PI * 2;
        }
        if (this.mLoopPhase < Math.PI * -2) {
            this.mLoopPhase += Math.PI * 2;
        }
        if (this.mLoopFrequency > this.mMaximumLoopFrequency) {
            this.mLoopFrequency = this.mMaximumLoopFrequency;
        }
        if (this.mLoopFrequency < -this.mMaximumLoopFrequency) {
            this.mLoopFrequency = -this.mMaximumLoopFrequency;
        }
        ++this.mBaudCounter;
        if ((double)this.mBaudCounter > this.mSymbolRate) {
            this.mBaudCounter = 0;
            this.mFrequencyError = (long)(this.mSampleRate / (Math.PI * 2) * this.mLoopFrequency);
            if (this.mFrequencyErrorProcessor != null) {
                this.mFrequencyErrorProcessor.processFrequencyError(this.mFrequencyError);
            }
        }
    }

    @Override
    public void reset() {
        this.mLoopPhase = 0.0;
        this.mLoopFrequency = 0.0;
    }
}

