/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk.pll;

import io.github.dsheirer.dsp.psk.pll.CostasLoop;
import io.github.dsheirer.dsp.psk.pll.IFrequencyErrorProcessor;
import io.github.dsheirer.dsp.psk.pll.PLLBandwidth;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import io.github.dsheirer.module.decode.FeedbackDecoder;
import io.github.dsheirer.source.SourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptivePLLBandwidthMonitor
implements ISyncDetectListener,
IFrequencyErrorProcessor {
    private static final Logger mLog = LoggerFactory.getLogger(AdaptivePLLBandwidthMonitor.class);
    private static final int MAX_SYNC_COUNT = PLLBandwidth.BW_200.getRangeEnd();
    private CostasLoop mCostasLoop;
    private FeedbackDecoder mFeedbackDecoder;
    private PLLBandwidth mPLLBandwidth = PLLBandwidth.BW_400;
    private int mSyncCount;

    public AdaptivePLLBandwidthMonitor(CostasLoop costasLoop, FeedbackDecoder feedbackDecoder) {
        this.mCostasLoop = costasLoop;
        this.mCostasLoop.setPLLBandwidth(this.mPLLBandwidth);
        this.mCostasLoop.setFrequencyErrorProcessor(this);
        this.mFeedbackDecoder = feedbackDecoder;
    }

    @Override
    public void syncDetected(int bitErrors) {
        ++this.mSyncCount;
        this.update();
    }

    @Override
    public void syncLost(int bitsProcessed) {
        this.mSyncCount -= 2;
        this.update();
    }

    private void update() {
        if (this.mSyncCount < 0) {
            this.mSyncCount = 0;
            return;
        }
        if (this.mSyncCount > MAX_SYNC_COUNT) {
            this.mSyncCount = MAX_SYNC_COUNT;
            return;
        }
        PLLBandwidth gain = PLLBandwidth.fromSyncCount(this.mSyncCount);
        if (gain != this.mPLLBandwidth) {
            this.mPLLBandwidth = gain;
            this.mCostasLoop.setPLLBandwidth(this.mPLLBandwidth);
        }
    }

    public void reset() {
        this.mSyncCount = 0;
        this.mPLLBandwidth = PLLBandwidth.BW_400;
        this.mCostasLoop.setPLLBandwidth(this.mPLLBandwidth);
    }

    @Override
    public void processFrequencyError(long frequencyError) {
        if (this.mPLLBandwidth != PLLBandwidth.BW_400 && this.mPLLBandwidth != PLLBandwidth.BW_300) {
            this.mFeedbackDecoder.broadcast(SourceEvent.frequencyErrorMeasurement(frequencyError));
        }
    }
}

