/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk;

import io.github.dsheirer.dsp.psk.InterpolatingSampleBuffer;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.Complex;
import io.github.dsheirer.sample.complex.ComplexSampleListener;
import io.github.dsheirer.sample.complex.ComplexSamples;

public abstract class PSKDemodulator<T>
implements ComplexSampleListener {
    private InterpolatingSampleBuffer mInterpolatingSampleBuffer;
    private IPhaseLockedLoop mPLL;
    private Complex mReceivedSample = new Complex(0.0f, 0.0f);
    private Listener<T> mSymbolListener;
    private boolean mRunning;

    public PSKDemodulator(InterpolatingSampleBuffer interpolatingSampleBuffer, IPhaseLockedLoop phaseLockedLoop) {
        this.mInterpolatingSampleBuffer = interpolatingSampleBuffer;
        this.mPLL = phaseLockedLoop;
    }

    public void start() {
        this.mRunning = true;
    }

    public void stop() {
        this.mRunning = false;
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void setSymbolListener(Listener<T> listener) {
        this.mSymbolListener = listener;
    }

    protected void broadcast(T symbol) {
        if (this.mSymbolListener != null) {
            this.mSymbolListener.receive(symbol);
        }
    }

    protected InterpolatingSampleBuffer getInterpolatingSampleBuffer() {
        return this.mInterpolatingSampleBuffer;
    }

    protected IPhaseLockedLoop getPLL() {
        return this.mPLL;
    }

    public void receive(ComplexSamples samples) {
        float[] i = samples.i();
        float[] q = samples.q();
        for (int x = 0; x < i.length; ++x) {
            if (!this.isRunning()) continue;
            this.receive(i[x], q[x]);
        }
    }

    @Override
    public void receive(float inphase, float quadrature) {
        this.mReceivedSample.setValues(inphase, quadrature);
        this.mReceivedSample.multiply(this.mPLL.incrementAndGetCurrentVector());
        this.mInterpolatingSampleBuffer.receive(this.mReceivedSample);
        if (this.mInterpolatingSampleBuffer.hasSymbol()) {
            this.calculateSymbol();
        }
    }

    protected abstract void calculateSymbol();

    public static float clip(float value, float maximum) {
        if (value > maximum) {
            return maximum;
        }
        if (value < -maximum) {
            return -maximum;
        }
        return value;
    }
}

