/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk;

import io.github.dsheirer.dsp.psk.DQPSKGardnerSymbolEvaluator;
import io.github.dsheirer.dsp.psk.InterpolatingSampleBuffer;
import io.github.dsheirer.dsp.psk.PSKDemodulator;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.sample.complex.Complex;

public class DQPSKGardnerDemodulator
extends PSKDemodulator<Dibit> {
    protected DQPSKGardnerSymbolEvaluator mSymbolEvaluator = new DQPSKGardnerSymbolEvaluator();
    private Complex mPreviousCurrentSample = new Complex(0.0f, 0.0f);
    private Complex mPreviousMiddleSample = new Complex(0.0f, 0.0f);
    private Complex mMiddleSymbol = new Complex(0.0f, 0.0f);
    protected Complex mCurrentSymbol = new Complex(0.0f, 0.0f);

    public DQPSKGardnerDemodulator(IPhaseLockedLoop phaseLockedLoop, InterpolatingSampleBuffer interpolatingSampleBuffer) {
        super(interpolatingSampleBuffer, phaseLockedLoop);
    }

    public void dispose() {
    }

    @Override
    protected void calculateSymbol() {
        Complex middleSample = this.getInterpolatingSampleBuffer().getCurrentSample();
        Complex currentSample = this.getInterpolatingSampleBuffer().getMiddleSample();
        this.mMiddleSymbol.setInphase(Complex.multiplyInphase(middleSample.inphase(), middleSample.quadrature(), this.mPreviousMiddleSample.inphase(), -this.mPreviousMiddleSample.quadrature()));
        this.mMiddleSymbol.setQuadrature(Complex.multiplyQuadrature(middleSample.inphase(), middleSample.quadrature(), this.mPreviousMiddleSample.inphase(), -this.mPreviousMiddleSample.quadrature()));
        this.mCurrentSymbol.setInphase(Complex.multiplyInphase(currentSample.inphase(), currentSample.quadrature(), this.mPreviousCurrentSample.inphase(), -this.mPreviousCurrentSample.quadrature()));
        this.mCurrentSymbol.setQuadrature(Complex.multiplyQuadrature(currentSample.inphase(), currentSample.quadrature(), this.mPreviousCurrentSample.inphase(), -this.mPreviousCurrentSample.quadrature()));
        this.mMiddleSymbol.normalize();
        this.mCurrentSymbol.normalize();
        this.mSymbolEvaluator.setSymbols(this.mMiddleSymbol, this.mCurrentSymbol);
        this.getInterpolatingSampleBuffer().resetAndAdjust(this.mSymbolEvaluator.getTimingError());
        this.getPLL().adjust(this.mSymbolEvaluator.getPhaseError());
        this.mPreviousMiddleSample.setValues(middleSample);
        this.mPreviousCurrentSample.setValues(currentSample);
        this.broadcast(this.mSymbolEvaluator.getSymbolDecision());
    }
}

