/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk;

import io.github.dsheirer.dsp.psk.IPSKSymbolEvaluator;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.sample.complex.Complex;

public class DQPSKDecisionDirectedSymbolEvaluator
implements IPSKSymbolEvaluator<Dibit> {
    private static final Complex ROTATE_FROM_PLUS_135 = Complex.fromAngle(-2.356194490192345);
    private static final Complex ROTATE_FROM_PLUS_45 = Complex.fromAngle(-0.7853981633974483);
    private static final Complex ROTATE_FROM_MINUS_45 = Complex.fromAngle(0.7853981633974483);
    private static final Complex ROTATE_FROM_MINUS_135 = Complex.fromAngle(2.356194490192345);
    private Complex mEvaluationSymbol = new Complex(0.0f, 0.0f);
    private float mPhaseError = 0.0f;
    private float mTimingError = 0.0f;
    private float mTimingErrorPolarity = 1.0f;
    private Dibit mSymbolDecision = Dibit.D00_PLUS_1;

    public void setSymbol(Complex preceding, Complex current) {
        this.mEvaluationSymbol.setValues(current);
        if (this.mEvaluationSymbol.quadrature() > 0.0f) {
            if (this.mEvaluationSymbol.inphase() > 0.0f) {
                this.mSymbolDecision = Dibit.D00_PLUS_1;
                this.mTimingErrorPolarity = preceding.quadrature() > current.quadrature() ? 1.0f : -1.0f;
                this.mEvaluationSymbol.multiply(ROTATE_FROM_PLUS_45);
            } else {
                this.mSymbolDecision = Dibit.D01_PLUS_3;
                this.mTimingErrorPolarity = preceding.quadrature() < current.quadrature() ? 1.0f : -1.0f;
                this.mEvaluationSymbol.multiply(ROTATE_FROM_PLUS_135);
            }
        } else if (this.mEvaluationSymbol.inphase() > 0.0f) {
            this.mSymbolDecision = Dibit.D10_MINUS_1;
            this.mTimingErrorPolarity = preceding.quadrature() > current.quadrature() ? 1.0f : -1.0f;
            this.mEvaluationSymbol.multiply(ROTATE_FROM_MINUS_45);
        } else {
            this.mSymbolDecision = Dibit.D11_MINUS_3;
            this.mTimingErrorPolarity = preceding.quadrature() < current.quadrature() ? 1.0f : -1.0f;
            this.mEvaluationSymbol.multiply(ROTATE_FROM_MINUS_135);
        }
        float errorNormalized = this.normalize(this.mEvaluationSymbol.quadrature(), 0.3f);
        this.mPhaseError = -errorNormalized;
        this.mTimingError = errorNormalized * this.mTimingErrorPolarity;
    }

    private static float clip(float value, float maximum) {
        if (value > maximum) {
            return maximum;
        }
        if (value < -maximum) {
            return -maximum;
        }
        return value;
    }

    private float normalize(float error, float maximum) {
        if (Float.isNaN(error)) {
            return 0.0f;
        }
        return DQPSKDecisionDirectedSymbolEvaluator.clip(error, maximum);
    }

    @Override
    public float getPhaseError() {
        return this.mPhaseError;
    }

    @Override
    public float getTimingError() {
        return this.mTimingError;
    }

    @Override
    public Dibit getSymbolDecision() {
        return this.mSymbolDecision;
    }
}

