/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.oscillator;

import io.github.dsheirer.dsp.oscillator.AbstractOscillator;
import io.github.dsheirer.dsp.oscillator.IRealOscillator;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorRealOscillator
extends AbstractOscillator
implements IRealOscillator {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_PREFERRED;
    private float[] mOffsets = new float[VECTOR_SPECIES.length()];

    public VectorRealOscillator(double frequency, double sampleRate) {
        super(frequency, sampleRate);
        for (int x = 0; x < this.mOffsets.length; ++x) {
            this.mOffsets[x] = (float)x + 1.0f;
        }
    }

    @Override
    public float[] generate(int sampleCount) {
        float[] samples = new float[sampleCount];
        for (int samplePointer = 0; samplePointer < sampleCount; samplePointer += VECTOR_SPECIES.length()) {
            FloatVector generated = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mOffsets, (int)0);
            generated = generated.mul(this.mAnglePerSample);
            generated = generated.add(this.mCurrentPhase);
            this.mCurrentPhase = generated.lane(VECTOR_SPECIES.length() - 1);
            this.mCurrentPhase = (float)((double)this.mCurrentPhase % (Math.PI * 2));
            generated = generated.lanewise(VectorOperators.SIN);
            generated.intoArray(samples, samplePointer);
        }
        return samples;
    }
}

