/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.oscillator;

import io.github.dsheirer.dsp.oscillator.AbstractOscillator;
import io.github.dsheirer.dsp.oscillator.IComplexOscillator;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.vector.VectorUtilities;
import java.util.Arrays;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorComplexOscillator
extends AbstractOscillator
implements IComplexOscillator {
    private static final Logger mLog = LoggerFactory.getLogger(VectorComplexOscillator.class);
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_PREFERRED;
    private float[] mPreviousInphases;
    private float[] mPreviousQuadratures;
    private float[] mGainInitials = new float[VECTOR_SPECIES.length()];

    public VectorComplexOscillator(double frequency, double sampleRate) {
        super(frequency, sampleRate);
        Arrays.fill(this.mGainInitials, 3.0f);
    }

    @Override
    protected void update() {
        super.update();
        float cosineAngle = (float)FastMath.cos((double)this.getAnglePerSample());
        float sineAngle = (float)FastMath.sin((double)this.getAnglePerSample());
        if (this.mPreviousInphases == null || this.mPreviousQuadratures == null) {
            this.mPreviousInphases = new float[VECTOR_SPECIES.length()];
            this.mPreviousQuadratures = new float[VECTOR_SPECIES.length()];
            this.mPreviousInphases[0] = 1.0f;
        }
        for (int x = 1; x < VECTOR_SPECIES.length(); ++x) {
            float gain = (3.0f - (this.mPreviousInphases[x - 1] * this.mPreviousInphases[x - 1] + this.mPreviousQuadratures[x - 1] * this.mPreviousQuadratures[x - 1])) / 2.0f;
            this.mPreviousInphases[x] = (this.mPreviousInphases[x - 1] * cosineAngle - this.mPreviousQuadratures[x - 1] * sineAngle) * gain;
            this.mPreviousQuadratures[x] = (this.mPreviousInphases[x - 1] * sineAngle + this.mPreviousQuadratures[x - 1] * cosineAngle) * gain;
        }
    }

    @Override
    public float[] generate(int sampleCount) {
        if (sampleCount % VECTOR_SPECIES.length() != 0) {
            throw new IllegalArgumentException("Requested sample count [" + sampleCount + "] must be a power of 2 and a multiple of the SIMD lane width [" + VECTOR_SPECIES.length() + "]");
        }
        float[] samples = new float[sampleCount * 2];
        FloatVector previousInphase = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mPreviousInphases, (int)0);
        FloatVector previousQuadrature = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mPreviousQuadratures, (int)0);
        FloatVector gainInitials = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mGainInitials, (int)0);
        float cosAngle = (float)FastMath.cos((double)(this.getAnglePerSample() * (float)VECTOR_SPECIES.length()));
        float sinAngle = (float)FastMath.sin((double)(this.getAnglePerSample() * (float)VECTOR_SPECIES.length()));
        int gainCounter = 0;
        for (int samplePointer = 0; samplePointer < sampleCount; samplePointer += VECTOR_SPECIES.length()) {
            FloatVector quadrature;
            FloatVector inphase;
            if (++gainCounter % 10 == 0) {
                FloatVector gain = gainInitials.sub((Vector)previousInphase.pow(2.0f).add((Vector)previousQuadrature.pow(2.0f))).div(2.0f);
                inphase = previousInphase.mul(cosAngle).sub((Vector)previousQuadrature.mul(sinAngle)).mul((Vector)gain);
                quadrature = previousInphase.mul(sinAngle).add((Vector)previousQuadrature.mul(cosAngle)).mul((Vector)gain);
            } else {
                inphase = previousInphase.mul(cosAngle).sub((Vector)previousQuadrature.mul(sinAngle));
                quadrature = previousInphase.mul(sinAngle).add((Vector)previousQuadrature.mul(cosAngle));
            }
            float[] interleaved = VectorUtilities.interleave(inphase, quadrature);
            System.arraycopy(interleaved, 0, samples, samplePointer * 2, interleaved.length);
            previousInphase = inphase;
            previousQuadrature = quadrature;
        }
        previousInphase.intoArray(this.mPreviousInphases, 0);
        previousQuadrature.intoArray(this.mPreviousQuadratures, 0);
        return samples;
    }

    @Override
    public ComplexSamples generateComplexSamples(int sampleCount, long timestamp) {
        if (sampleCount % VECTOR_SPECIES.length() != 0) {
            throw new IllegalArgumentException("Requested sample count [" + sampleCount + "] must be a power of 2 and a multiple of the SIMD lane width [" + VECTOR_SPECIES.length() + "]");
        }
        float[] iSamples = new float[sampleCount];
        float[] qSamples = new float[sampleCount];
        FloatVector previousInphase = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mPreviousInphases, (int)0);
        FloatVector previousQuadrature = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mPreviousQuadratures, (int)0);
        FloatVector gainInitials = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mGainInitials, (int)0);
        float cosAngle = (float)FastMath.cos((double)(this.getAnglePerSample() * (float)VECTOR_SPECIES.length()));
        float sinAngle = (float)FastMath.sin((double)(this.getAnglePerSample() * (float)VECTOR_SPECIES.length()));
        for (int samplePointer = 0; samplePointer < sampleCount; samplePointer += VECTOR_SPECIES.length()) {
            FloatVector gain = gainInitials.sub((Vector)previousInphase.pow(2.0f).add((Vector)previousQuadrature.pow(2.0f))).div(2.0f);
            FloatVector inphase = previousInphase.mul(cosAngle).sub((Vector)previousQuadrature.mul(sinAngle)).mul((Vector)gain);
            FloatVector quadrature = previousInphase.mul(sinAngle).add((Vector)previousQuadrature.mul(cosAngle)).mul((Vector)gain);
            inphase.intoArray(iSamples, samplePointer);
            quadrature.intoArray(qSamples, samplePointer);
            previousInphase = inphase;
            previousQuadrature = quadrature;
        }
        previousInphase.intoArray(this.mPreviousInphases, 0);
        previousQuadrature.intoArray(this.mPreviousQuadratures, 0);
        return new ComplexSamples(iSamples, qSamples, timestamp);
    }
}

