/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.oscillator;

import io.github.dsheirer.dsp.oscillator.IComplexOscillator;
import io.github.dsheirer.dsp.oscillator.IRealOscillator;
import io.github.dsheirer.dsp.oscillator.ScalarComplexOscillator;
import io.github.dsheirer.dsp.oscillator.ScalarRealOscillator;
import io.github.dsheirer.dsp.oscillator.VectorComplexOscillator;
import io.github.dsheirer.dsp.oscillator.VectorRealOscillator;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OscillatorFactory {
    private static final Logger mLog = LoggerFactory.getLogger(OscillatorFactory.class);

    public static IRealOscillator getRealOscillator(double frequency, double sampleRate) {
        Implementation operation = CalibrationManager.getInstance().getImplementation(CalibrationType.OSCILLATOR_REAL);
        switch (operation) {
            case VECTOR_SIMD_PREFERRED: {
                return new VectorRealOscillator(frequency, sampleRate);
            }
        }
        return new ScalarRealOscillator(frequency, sampleRate);
    }

    public static IComplexOscillator getComplexOscillator(double frequency, double sampleRate) {
        Implementation operation = CalibrationManager.getInstance().getImplementation(CalibrationType.OSCILLATOR_COMPLEX);
        switch (operation) {
            case VECTOR_SIMD_PREFERRED: {
                return new VectorComplexOscillator(frequency, sampleRate);
            }
        }
        return new ScalarComplexOscillator(frequency, sampleRate);
    }
}

