/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.oscillator;

import io.github.dsheirer.sample.complex.ComplexSamples;

public class FS4DownConverter {
    private int mPointer = 0;

    public float[] mixComplex(float[] samples) {
        int pointer = this.mPointer;
        for (int x = 0; x < samples.length; x += 2) {
            switch (pointer) {
                case 0: {
                    break;
                }
                case 1: {
                    float real = samples[x];
                    samples[x] = samples[x + 1];
                    samples[x + 1] = -real;
                    break;
                }
                case 2: {
                    samples[x] = -samples[x];
                    samples[x + 1] = -samples[x + 1];
                    break;
                }
                case 3: {
                    float real = samples[x];
                    samples[x] = -samples[x + 1];
                    samples[x + 1] = real;
                }
            }
            ++pointer;
            pointer %= 4;
        }
        this.mPointer = pointer;
        return samples;
    }

    public ComplexSamples mixComplex(ComplexSamples samples) {
        int pointer = this.mPointer;
        float[] i = samples.i();
        float[] q = samples.q();
        for (int x = 0; x < i.length; ++x) {
            switch (pointer) {
                case 0: {
                    break;
                }
                case 1: {
                    float temp = i[x];
                    i[x] = q[x];
                    q[x] = -temp;
                    break;
                }
                case 2: {
                    i[x] = -i[x];
                    q[x] = -q[x];
                    break;
                }
                case 3: {
                    float temp = i[x];
                    i[x] = -q[x];
                    q[x] = temp;
                }
            }
            ++pointer;
            pointer %= 4;
        }
        this.mPointer = pointer;
        return samples;
    }
}

