/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.oscillator;

import io.github.dsheirer.dsp.oscillator.IOscillator;

public abstract class AbstractOscillator
implements IOscillator {
    protected static final double TWO_PI = Math.PI * 2;
    private double mFrequency;
    private double mSampleRate;
    protected float mAnglePerSample;
    protected float mCurrentPhase = 0.0f;

    protected AbstractOscillator(double frequency, double sampleRate) {
        this.mFrequency = frequency;
        this.mSampleRate = sampleRate;
        this.update();
    }

    protected float getAnglePerSample() {
        return this.mAnglePerSample;
    }

    protected void update() {
        this.mAnglePerSample = (float)(Math.PI * 2 * this.getFrequency() / this.getSampleRate());
    }

    @Override
    public double getFrequency() {
        return this.mFrequency;
    }

    @Override
    public void setFrequency(double frequency) {
        this.mFrequency = frequency;
        this.update();
    }

    @Override
    public boolean hasFrequency() {
        return this.mFrequency != 0.0;
    }

    @Override
    public double getSampleRate() {
        return this.mSampleRate;
    }

    @Override
    public void setSampleRate(double sampleRate) {
        this.mSampleRate = sampleRate;
        this.update();
    }

    @Override
    public boolean isEnabled() {
        return this.mFrequency != 0.0;
    }
}

