/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.oscillator;

import io.github.dsheirer.dsp.oscillator.IComplexOscillator;
import io.github.dsheirer.sample.complex.ComplexSamples;
import java.util.Random;

public class AWGNOscillator
implements IComplexOscillator {
    private final Random mRandom = new Random();
    private IComplexOscillator mComplexOscillator;
    private float mNoiseScale;

    public AWGNOscillator(IComplexOscillator complexOscillator, float noiseScale) {
        this.mComplexOscillator = complexOscillator;
        this.mNoiseScale = noiseScale;
    }

    private float nextNoise() {
        return (float)this.mRandom.nextGaussian() * this.mNoiseScale;
    }

    @Override
    public float[] generate(int sampleCount) {
        float[] generated = this.mComplexOscillator.generate(sampleCount);
        int x = 0;
        while (x < generated.length) {
            int n = x++;
            generated[n] = generated[n] + this.nextNoise();
        }
        return generated;
    }

    @Override
    public ComplexSamples generateComplexSamples(int sampleCount, long timestamp) {
        ComplexSamples samples = this.mComplexOscillator.generateComplexSamples(sampleCount, timestamp);
        int x = 0;
        while (x < samples.i().length) {
            float[] fArray = samples.i();
            int n = x;
            fArray[n] = fArray[n] + this.nextNoise();
            float[] fArray2 = samples.q();
            int n2 = x++;
            fArray2[n2] = fArray2[n2] + this.nextNoise();
        }
        return samples;
    }

    @Override
    public double getFrequency() {
        return this.mComplexOscillator.getFrequency();
    }

    @Override
    public void setFrequency(double frequency) {
        this.mComplexOscillator.setFrequency(frequency);
    }

    @Override
    public boolean hasFrequency() {
        return this.mComplexOscillator.hasFrequency();
    }

    @Override
    public double getSampleRate() {
        return this.mComplexOscillator.getSampleRate();
    }

    @Override
    public void setSampleRate(double sampleRate) {
        this.mComplexOscillator.setSampleRate(sampleRate);
    }

    @Override
    public boolean isEnabled() {
        return this.mComplexOscillator.isEnabled();
    }
}

