/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.gain.complex;

import io.github.dsheirer.dsp.gain.complex.IComplexGainControl;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorComplexGainControl
implements IComplexGainControl {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_PREFERRED;
    private static final float OBJECTIVE_ENVELOPE = 1.0f;
    private static final float MINIMUM_ENVELOPE = 1.0E-4f;
    private static final float ENVELOPE_ESTIMATE = 0.4f;

    @Override
    public ComplexSamples process(float[] i, float[] q, long timestamp) {
        VectorUtilities.checkComplexArrayLength(i, q, VECTOR_SPECIES);
        FloatVector maxEnvelope = FloatVector.zero(VECTOR_SPECIES).add(1.0E-4f);
        for (int bufferPointer = 0; bufferPointer < i.length; bufferPointer += VECTOR_SPECIES.length()) {
            FloatVector iAbs = FloatVector.fromArray(VECTOR_SPECIES, (float[])i, (int)bufferPointer).abs();
            FloatVector qAbs = FloatVector.fromArray(VECTOR_SPECIES, (float[])q, (int)bufferPointer).abs();
            maxEnvelope = maxEnvelope.max((Vector)iAbs.add((Vector)qAbs.mul(0.4f)));
            maxEnvelope = maxEnvelope.max((Vector)qAbs.add((Vector)iAbs.mul(0.4f)));
        }
        float gain = 1.0f / maxEnvelope.reduceLanes(VectorOperators.MAX);
        float[] iProcessed = new float[i.length];
        float[] qProcessed = new float[q.length];
        for (int bufferPointer = 0; bufferPointer < i.length; bufferPointer += VECTOR_SPECIES.length()) {
            FloatVector.fromArray(VECTOR_SPECIES, (float[])i, (int)bufferPointer).mul(gain).intoArray(iProcessed, bufferPointer);
            FloatVector.fromArray(VECTOR_SPECIES, (float[])q, (int)bufferPointer).mul(gain).intoArray(qProcessed, bufferPointer);
        }
        return new ComplexSamples(iProcessed, qProcessed, timestamp);
    }
}

