/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.gain;

import io.github.dsheirer.buffer.FloatCircularBuffer;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticGainControl {
    private static final Logger mLog = LoggerFactory.getLogger(AutomaticGainControl.class);
    private static final float SAMPLE_RATE = 8000.0f;
    private static final float DELAY_TIME_CONSTANT = 0.015f;
    private static final float WINDOW_TIME_CONSTANT = 0.018f;
    private static final float ATTACK_RISE_TIME_CONSTANT = 0.002f;
    private static final float ATTACK_FALL_TIME_CONSTANT = 0.005f;
    private static final float ATTACK_RISE_ALPHA = 1.0f - (float)FastMath.exp((double)-2.500000118743628E-7);
    private static final float ATTACK_FALL_ALPHA = 1.0f - (float)FastMath.exp((double)-6.249999860301614E-7);
    private static final float DECAY = 200.0f;
    private static final float DECAY_RISEFALL_RATIO = 0.3f;
    private static final float DECAY_RISE_ALPHA = 1.0f - (float)FastMath.exp((double)-0.0020833332505491076);
    private static final float DECAY_FALL_ALPHA = 1.0f - (float)FastMath.exp((double)-6.25E-4);
    private static final float MAX_AMPLITUDE = 1.0f;
    private static final float MAX_MANUAL_AMPLITUDE = 1.0f;
    private static final float MANUAL_GAIN = 0.0f;
    private static final float MANUAL_AGC_GAIN = 1.0f * (float)FastMath.pow((double)10.0, (double)0.0);
    private static final float AGC_OUT_SCALE = 0.95f;
    private static final float SLOPE_FACTOR = 2.0f;
    private static final float THRESHOLD = -20.0f;
    private static final float KNEE = -1.0f;
    private static final float GAIN_SLOPE = 0.02f;
    private static final float FIXED_GAIN = 0.95f * (float)FastMath.pow((double)10.0, (double)0.9800000004470348);
    private static final float MIN_CONSTANT = 3.2767E-4f;
    private boolean mAGCEnabled = true;
    private float mPeakMagnitude = -5.0f;
    private float mAttackAverage = 0.0f;
    private float mDecayAverage = 0.0f;
    private FloatCircularBuffer mDelayBuffer = new FloatCircularBuffer(120);
    private FloatCircularBuffer mMagnitudeBuffer = new FloatCircularBuffer(144, this.mPeakMagnitude);
    private float mMaxGain = 0.0f;
    private float mMinGain = 100000.0f;

    public AutomaticGainControl() {
        System.out.println("Fixed gain: " + FIXED_GAIN + " Knee: -1.0 Gain Slope:0.02");
        System.out.println("Manual gain: " + MANUAL_AGC_GAIN);
    }

    public void reset() {
        mLog.info("Previous - Min Gain: " + this.mMinGain + " Max Gain: " + this.mMaxGain);
        mLog.info("Resetting - Peak:" + this.mPeakMagnitude + " Attack:" + this.mAttackAverage + " Decay:" + this.mDecayAverage + " Mag Max:" + this.mMagnitudeBuffer.max(this.mPeakMagnitude));
        this.mPeakMagnitude = -8.0f;
        this.mAttackAverage = -8.0f;
        this.mDecayAverage = -8.0f;
        this.mDelayBuffer.reset(0.0f);
        this.mMagnitudeBuffer.reset(this.mPeakMagnitude);
    }

    public float[] process(float[] input) {
        float[] output = new float[input.length];
        for (int x = 0; x < input.length; ++x) {
            output[x] = this.process(input[x]);
        }
        return output;
    }

    public float process(float currentSample) {
        float delayedSample = this.mDelayBuffer.get(currentSample);
        float gain = MANUAL_AGC_GAIN;
        if (this.mAGCEnabled) {
            float currentMagnitude = (float)(FastMath.log10((double)(FastMath.abs((float)currentSample) + 3.2767E-4f)) - FastMath.log10((double)1.0));
            float delayedMagnitude = this.mMagnitudeBuffer.get(currentMagnitude);
            if (currentMagnitude > this.mPeakMagnitude) {
                this.mPeakMagnitude = currentMagnitude;
            } else if (delayedMagnitude == this.mPeakMagnitude) {
                this.mPeakMagnitude = this.mMagnitudeBuffer.max(-3.4845634f);
            }
            this.mAttackAverage = this.mPeakMagnitude > this.mAttackAverage ? (1.0f - ATTACK_RISE_ALPHA) * this.mAttackAverage + ATTACK_RISE_ALPHA * this.mPeakMagnitude : (1.0f - ATTACK_FALL_ALPHA) * this.mAttackAverage + ATTACK_FALL_ALPHA * this.mPeakMagnitude;
            this.mDecayAverage = this.mPeakMagnitude > this.mDecayAverage ? (1.0f - DECAY_RISE_ALPHA) * this.mDecayAverage + DECAY_RISE_ALPHA * this.mPeakMagnitude : (1.0f - DECAY_FALL_ALPHA) * this.mDecayAverage + DECAY_RISE_ALPHA * this.mPeakMagnitude;
            float magnitude = FastMath.max((float)this.mAttackAverage, (float)this.mDecayAverage);
            gain = magnitude < -1.0f ? FIXED_GAIN : 0.95f * (float)FastMath.pow((double)10.0, (double)((double)magnitude * -0.9800000004470348));
            System.out.println("Current Mag: " + currentMagnitude + " Delay Mag: " + delayedMagnitude + " Peak:" + this.mPeakMagnitude + " Gain:" + gain + " Attack Avg:" + this.mAttackAverage + " Decay Avg:" + this.mDecayAverage);
        }
        if (gain < this.mMinGain) {
            this.mMinGain = gain;
        }
        if (gain > this.mMaxGain) {
            this.mMaxGain = gain;
        }
        return delayedSample * gain;
    }

    public void setAGCEnabled(boolean enabled) {
        this.mAGCEnabled = enabled;
    }

    public boolean isAGCEnabled() {
        return this.mAGCEnabled;
    }
}

