/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.fsk;

import org.apache.commons.math3.util.FastMath;

public class ZeroCrossingErrorDetector {
    protected boolean[] mBuffer;
    protected float mZeroCrossingIdeal;
    protected float mZeroCrossingOne;
    protected float mZeroCrossingTwo;
    protected float mDetectedZeroCrossing;
    private int mZeroCrossingCount;

    public ZeroCrossingErrorDetector(float samplesPerSymbol) {
        this.mBuffer = new boolean[(int)FastMath.ceil((double)samplesPerSymbol)];
        this.mZeroCrossingIdeal = samplesPerSymbol / 2.0f;
    }

    public void receive(boolean sample) {
        System.arraycopy(this.mBuffer, 1, this.mBuffer, 0, this.mBuffer.length - 1);
        this.mBuffer[this.mBuffer.length - 1] = sample;
    }

    public float getError() {
        this.mZeroCrossingCount = 0;
        for (int x = 0; x < this.mBuffer.length - 1; ++x) {
            if (!(this.mBuffer[x] ^ this.mBuffer[x + 1])) continue;
            if (this.mZeroCrossingCount == 0) {
                ++this.mZeroCrossingCount;
                this.mZeroCrossingOne = (float)x + 0.5f;
                continue;
            }
            if (this.mZeroCrossingCount == 1) {
                ++this.mZeroCrossingCount;
                this.mZeroCrossingTwo = (float)x + 0.5f;
                continue;
            }
            return 0.0f;
        }
        if (this.mZeroCrossingCount == 1) {
            this.mDetectedZeroCrossing = this.mZeroCrossingOne;
            return this.mZeroCrossingIdeal - this.mZeroCrossingOne;
        }
        if (this.mZeroCrossingCount == 2) {
            float errorDistanceOne = this.mZeroCrossingIdeal - this.mZeroCrossingOne;
            float errorDistanceTwo = (float)this.mZeroCrossingCount - this.mZeroCrossingTwo;
            this.mDetectedZeroCrossing = FastMath.abs((float)errorDistanceOne) < FastMath.abs((float)errorDistanceTwo) ? this.mZeroCrossingOne : this.mZeroCrossingTwo;
            return this.mZeroCrossingIdeal - this.mDetectedZeroCrossing;
        }
        return 0.0f;
    }
}

