/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.fsk;

import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleBuffer {
    private static final Logger mLog = LoggerFactory.getLogger(SampleBuffer.class);
    protected boolean[] mDelayLine;
    protected int mDelayLinePointer = 0;
    protected int mTwiceSamplesPerSymbol;
    private int mIntegerSamplesPerSymbol;
    private int mHalfIntegerSamplesPerSymbol;
    private int mPositiveSampleDecisionCount;
    protected int mSymbolStart;
    protected int mSymbolEnd;
    protected float mSamplesPerSymbol;
    protected float mMidSymbolSamplingPoint;
    protected float mSymbolTimingGain;

    public SampleBuffer(float samplesPerSymbol, float symbolTimingGain) {
        this.mSamplesPerSymbol = samplesPerSymbol;
        this.mSymbolTimingGain = symbolTimingGain;
        this.mIntegerSamplesPerSymbol = (int)(samplesPerSymbol + 0.5f);
        this.mHalfIntegerSamplesPerSymbol = (int)(samplesPerSymbol / 2.0f + 0.5f);
        this.mMidSymbolSamplingPoint = samplesPerSymbol + (float)this.mHalfIntegerSamplesPerSymbol;
        this.mTwiceSamplesPerSymbol = (int)FastMath.floor((double)(2.0 * (double)samplesPerSymbol));
        this.mDelayLine = new boolean[2 * this.mTwiceSamplesPerSymbol];
    }

    public void receive(boolean sample) {
        this.mMidSymbolSamplingPoint -= 1.0f;
        this.mDelayLine[this.mDelayLinePointer] = sample;
        this.mDelayLine[this.mDelayLinePointer + this.mTwiceSamplesPerSymbol] = sample;
        ++this.mDelayLinePointer;
        this.mDelayLinePointer %= this.mTwiceSamplesPerSymbol;
    }

    public void resetAndAdjust(float symbolTimingError) {
        this.mMidSymbolSamplingPoint += this.mSamplesPerSymbol + symbolTimingError * this.mSymbolTimingGain;
    }

    public void setTimingGain(float gain) {
        this.mSymbolTimingGain = gain;
    }

    public boolean hasSymbol() {
        return this.mMidSymbolSamplingPoint < 1.0f;
    }

    public boolean getSymbol() {
        this.mPositiveSampleDecisionCount = 0;
        this.mSymbolStart = this.mDelayLinePointer + this.mHalfIntegerSamplesPerSymbol;
        this.mSymbolEnd = this.mSymbolStart + this.mIntegerSamplesPerSymbol;
        for (int x = this.mSymbolStart; x < this.mSymbolEnd; ++x) {
            if (!this.mDelayLine[x]) continue;
            ++this.mPositiveSampleDecisionCount;
        }
        return this.mPositiveSampleDecisionCount > this.mHalfIntegerSamplesPerSymbol;
    }
}

