/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.fsk;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.filter.fir.remez.RemezFIRFilterDesigner;
import io.github.dsheirer.sample.Listener;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRDecoder
implements Listener<float[]> {
    private static final Logger mLog = LoggerFactory.getLogger(LTRDecoder.class);
    private static final double SLOPE_CALCULATION_SUM_XX = 1637.999992057681;
    private static final float BAUD_LENGTH = 26.666666f;
    private static final float SLOPE_THRESHOLD = 0.0048f;
    private static final int MAX_ONES_SEQUENCE = 18;
    private static final int OVERLAP = 26;
    private static final int POST_TRANSITION_SAMPLES_TO_SKIP = 26;
    private static final int SLOPE_CALCULATION_LENGTH = 27;
    private static final int SYMBOL_TRANSITION_IDEAL_MIN = 11;
    private static final int SYMBOL_TRANSITION_IDEAL_MAX = 16;
    private static float[] sLowPassFilterCoefficients;
    private boolean mSymbol = false;
    private float[] mResidual = new float[26];
    private float mBaudCounter = 0.0f;
    private float mMaxSlope = 0.0f;
    private int mExcessiveOneSequenceCounter = 0;
    private Listener<boolean[]> mSymbolListener;
    private IRealFilter mLowPassFilter = FilterFactory.getRealFilter(sLowPassFilterCoefficients);

    public void setListener(Listener<boolean[]> listener) {
        this.mSymbolListener = listener;
    }

    @Override
    public void receive(float[] samples) {
        if (this.mSymbolListener != null) {
            float[] filtered = this.mLowPassFilter.filter(samples);
            int timingAdjust = 0;
            int samplesToSkip = 0;
            float[] buffer = new float[filtered.length + 26];
            boolean[] symbols = new boolean[(int)(((float)filtered.length + this.mBaudCounter) / 26.666666f)];
            int symbolPointer = 0;
            float slope = 0.0f;
            try {
                System.arraycopy(this.mResidual, 0, buffer, 0, this.mResidual.length);
                System.arraycopy(filtered, 0, buffer, this.mResidual.length, filtered.length);
                System.arraycopy(filtered, filtered.length - 26, this.mResidual, 0, 26);
                for (int bufferPointer = 0; bufferPointer < samples.length; ++bufferPointer) {
                    if (samplesToSkip > 0) {
                        --samplesToSkip;
                    } else {
                        slope = this.calculateSlope(buffer, bufferPointer);
                        if (this.mSymbol) {
                            if (slope > this.mMaxSlope && this.mMaxSlope < -0.0048f) {
                                this.mSymbol = false;
                                timingAdjust = this.mBaudCounter < 11.0f ? 1 : (this.mBaudCounter > 16.0f ? -1 : 0);
                                this.mBaudCounter += (float)timingAdjust;
                                samplesToSkip = 26 + timingAdjust;
                            } else if (slope < this.mMaxSlope) {
                                this.mMaxSlope = slope;
                            }
                        } else if (slope < this.mMaxSlope && this.mMaxSlope > 0.0048f) {
                            this.mSymbol = true;
                            timingAdjust = this.mBaudCounter < 11.0f ? 1 : (this.mBaudCounter > 16.0f ? -1 : 0);
                            this.mBaudCounter += (float)timingAdjust;
                            samplesToSkip = 26 + timingAdjust;
                        } else if (slope > this.mMaxSlope) {
                            this.mMaxSlope = slope;
                        }
                    }
                    this.mBaudCounter += 1.0f;
                    if (!(this.mBaudCounter > 26.666666f)) continue;
                    if (symbolPointer >= symbols.length) {
                        symbols = Arrays.copyOf(symbols, symbols.length + 1);
                    }
                    symbols[symbolPointer++] = this.mSymbol;
                    this.mBaudCounter -= 26.666666f;
                    if (this.mSymbol) {
                        ++this.mExcessiveOneSequenceCounter;
                        if (this.mExcessiveOneSequenceCounter <= 18) continue;
                        this.mSymbol = false;
                        this.mMaxSlope = -1.0f;
                        this.mExcessiveOneSequenceCounter = 0;
                        continue;
                    }
                    this.mExcessiveOneSequenceCounter = 0;
                }
            }
            catch (Exception e) {
                mLog.warn("Unexpected error while processing LTR samples", (Throwable)e);
            }
            if (symbolPointer != symbols.length) {
                this.mSymbolListener.receive(Arrays.copyOf(symbols, symbolPointer));
            } else {
                this.mSymbolListener.receive(symbols);
            }
        }
    }

    public float calculateSlope(float[] samples, int offset) {
        double xbar = 0.0;
        double ybar = samples[offset];
        double sumXY = 0.0;
        for (int x = 1; x < 27; ++x) {
            double fact1 = 1.0f + (float)x;
            double dx = (double)x - xbar;
            double dy = (double)samples[offset + x] - ybar;
            sumXY += dx * dy * (double)((float)x / (1.0f + (float)x));
            xbar += dx / fact1;
            ybar += dy / fact1;
        }
        return (float)(sumXY / 1637.999992057681);
    }

    static {
        FIRFilterSpecification specification = FIRFilterSpecification.lowPassBuilder().sampleRate(8000.0).gridDensity(16).oddLength(true).passBandCutoff(300.0).passBandAmplitude(1.0).passBandRipple(0.01).stopBandStart(500.0).stopBandAmplitude(0.0).stopBandRipple(0.03).build();
        try {
            RemezFIRFilterDesigner designer = new RemezFIRFilterDesigner(specification);
            if (designer.isValid()) {
                sLowPassFilterCoefficients = designer.getImpulseResponse();
            }
        }
        catch (FilterDesignException fde) {
            mLog.error("Filter design error", (Throwable)fde);
        }
    }
}

