/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.fm;

import io.github.dsheirer.dsp.fm.IDemodulator;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorFMDemodulator512
implements IDemodulator {
    private static final Logger mLog = LoggerFactory.getLogger(VectorFMDemodulator512.class);
    protected static final float ZERO = 0.0f;
    private static final int BUFFER_OVERLAP = 1;
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_512;
    private float[] mIBuffer = new float[1];
    private float[] mQBuffer = new float[1];

    @Override
    public float[] demodulate(float[] i, float[] q) {
        VectorUtilities.checkComplexArrayLength(i, q, VECTOR_SPECIES);
        if (this.mIBuffer.length != i.length + 1) {
            this.mIBuffer = new float[i.length + 1];
            this.mQBuffer = new float[q.length + 1];
        }
        this.mIBuffer[0] = this.mIBuffer[this.mIBuffer.length - 1];
        this.mQBuffer[0] = this.mQBuffer[this.mQBuffer.length - 1];
        System.arraycopy(i, 0, this.mIBuffer, 1, i.length);
        System.arraycopy(q, 0, this.mQBuffer, 1, q.length);
        float[] demodulated = new float[i.length];
        for (int bufferPointer = 0; bufferPointer < this.mIBuffer.length - 1; bufferPointer += VECTOR_SPECIES.length()) {
            FloatVector previousI = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mIBuffer, (int)bufferPointer);
            FloatVector previousQ = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)bufferPointer);
            FloatVector currentI = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mIBuffer, (int)(bufferPointer + 1));
            FloatVector currentQ = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(bufferPointer + 1));
            FloatVector demodI = currentI.mul((Vector)previousI).sub((Vector)currentQ.mul((Vector)previousQ.neg()));
            FloatVector demodQ = currentQ.mul((Vector)previousI).add((Vector)currentI.mul((Vector)previousQ.neg()));
            demodI = demodI.add(Float.MIN_VALUE, demodQ.eq(0.0f));
            FloatVector demod = demodQ.div((Vector)demodI).lanewise(VectorOperators.ATAN);
            demod.intoArray(demodulated, bufferPointer);
        }
        return demodulated;
    }
}

