/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.fm;

import io.github.dsheirer.dsp.fm.FmDemodulatorFactory;
import io.github.dsheirer.dsp.fm.IDemodulator;
import io.github.dsheirer.dsp.fm.ISquelchingDemodulator;
import io.github.dsheirer.dsp.magnitude.IMagnitudeCalculator;
import io.github.dsheirer.dsp.magnitude.MagnitudeFactory;
import io.github.dsheirer.dsp.squelch.AdaptiveSquelch;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SquelchingFMDemodulator
implements ISquelchingDemodulator,
Listener<SourceEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(SquelchingFMDemodulator.class);
    private static final float ZERO = 0.0f;
    private final AdaptiveSquelch mAdaptiveSquelch;
    private final IMagnitudeCalculator mMagnitude = MagnitudeFactory.getMagnitudeCalculator();
    private final IDemodulator mFmDemodulator = FmDemodulatorFactory.getFmDemodulator();
    private boolean mSquelchChanged = false;

    public SquelchingFMDemodulator(float alpha, float squelchThreshold, boolean squelchAutoTrack) {
        this.mAdaptiveSquelch = new AdaptiveSquelch(alpha, squelchThreshold, squelchAutoTrack);
    }

    @Override
    public void setSampleRate(int sampleRate) {
        this.mAdaptiveSquelch.setSampleRate(sampleRate);
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mAdaptiveSquelch.setSourceEventListener(listener);
    }

    @Override
    public float[] demodulate(float[] i, float[] q) {
        this.setSquelchChanged(false);
        float[] demodulated = this.mFmDemodulator.demodulate(i, q);
        float[] magnitude = this.mMagnitude.calculate(i, q);
        for (int x = 0; x < magnitude.length; ++x) {
            this.mAdaptiveSquelch.process(magnitude[x]);
            if (!this.mAdaptiveSquelch.isUnmuted()) {
                demodulated[x] = 0.0f;
            }
            if (!this.mAdaptiveSquelch.isSquelchChanged()) continue;
            this.setSquelchChanged(true);
        }
        return demodulated;
    }

    @Override
    public void setSquelchThreshold(float threshold) {
        this.mAdaptiveSquelch.setSquelchThreshold(threshold);
    }

    @Override
    public void setSquelchAutoTrack(boolean autoTrack) {
        this.mAdaptiveSquelch.setSquelchAutoTrack(autoTrack);
    }

    @Override
    public boolean isSquelchChanged() {
        return this.mSquelchChanged;
    }

    private void setSquelchChanged(boolean changed) {
        this.mSquelchChanged = changed;
    }

    @Override
    public boolean isMuted() {
        return this.mAdaptiveSquelch.isMuted();
    }

    @Override
    public void receive(SourceEvent sourceEvent) {
        switch (sourceEvent.getEvent()) {
            case REQUEST_CURRENT_SQUELCH_THRESHOLD: 
            case REQUEST_CHANGE_SQUELCH_THRESHOLD: 
            case REQUEST_CURRENT_SQUELCH_AUTO_TRACK: 
            case REQUEST_CHANGE_SQUELCH_AUTO_TRACK: {
                this.mAdaptiveSquelch.receive(sourceEvent);
            }
        }
    }
}

