/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.smoothing;

import java.util.Map;
import java.util.Set;

public abstract class SmoothingFilter {
    public static final int SMOOTHING_MINIMUM = 3;
    public static final int SMOOTHING_MAXIMUM = 29;
    public static final int SMOOTHING_DEFAULT = 9;
    private Map<Integer, float[]> mCoefficientMap;
    private float[] mCoefficients;
    private float[] mNewCoefficients;
    private boolean mNewCoefficientsAvailable;

    public SmoothingFilter(Map<Integer, float[]> coefficients, int index) {
        this.mCoefficientMap = coefficients;
        if (this.mCoefficientMap != null) {
            this.mCoefficients = this.mCoefficientMap.get(index);
        }
    }

    public abstract SmoothingType getSmoothingType();

    public Set<Integer> getPointSizeList() {
        return this.mCoefficientMap.keySet();
    }

    public int getPointSize() {
        return this.mCoefficients.length;
    }

    public void setPointSize(int pointSize) {
        if (this.mCoefficientMap != null) {
            if (this.mCoefficientMap.containsKey(pointSize)) {
                this.mNewCoefficients = this.mCoefficientMap.get(pointSize);
                this.mNewCoefficientsAvailable = true;
            } else {
                throw new IllegalArgumentException("Point size [" + pointSize + "] is not valid in the current coefficient map");
            }
        }
    }

    public float[] filter(float[] data) {
        if (this.mNewCoefficientsAvailable) {
            this.mCoefficients = this.mNewCoefficients;
            this.mNewCoefficientsAvailable = false;
        }
        int middle = this.mCoefficients.length / 2;
        float[] filtered = new float[data.length];
        int toCopy = middle;
        System.arraycopy(data, 0, filtered, 0, toCopy);
        System.arraycopy(data, data.length - toCopy, filtered, filtered.length - toCopy, toCopy);
        for (int x = 0; x < data.length - this.mCoefficients.length + 1; ++x) {
            float accumulator = 0.0f;
            for (int y = 0; y < this.mCoefficients.length; ++y) {
                accumulator += data[x + y] * this.mCoefficients[y];
            }
            filtered[x + middle] = accumulator;
        }
        return filtered;
    }

    public static enum SmoothingType {
        NONE,
        RECTANGLE,
        TRIANGLE,
        GAUSSIAN;

    }
}

