/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.resample;

import com.laszlosystems.libresample4j.Resampler;
import com.laszlosystems.libresample4j.SampleBuffers;
import io.github.dsheirer.sample.Listener;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealResampler {
    protected static final Logger mLog = LoggerFactory.getLogger(RealResampler.class);
    private Resampler mResampler;
    private Listener<float[]> mResampledListener;
    private BufferManager mBufferManager;
    private double mResampleFactor;

    public RealResampler(double inputRate, double outputRate, int bufferSize, int outputArrayLength) {
        this.mResampleFactor = outputRate / inputRate;
        this.mResampler = new Resampler(true, this.mResampleFactor, this.mResampleFactor);
        this.mBufferManager = new BufferManager(bufferSize, outputArrayLength);
    }

    public double getResampleFactor() {
        return this.mResampleFactor;
    }

    public List<float[]> resample(List<float[]> audioPackets) {
        ArrayList<float[]> resampled = new ArrayList<float[]>();
        this.mResampledListener = resampledAudio -> resampled.add((float[])resampledAudio);
        for (int x = 0; x < audioPackets.size(); ++x) {
            if (x == audioPackets.size() - 1) {
                this.resample(audioPackets.get(x), true);
                continue;
            }
            this.resample(audioPackets.get(x));
        }
        this.mResampledListener = null;
        return resampled;
    }

    public void resample(float[] samples) {
        this.resample(samples, false);
    }

    public void resample(float[] samples, boolean lastBatch) {
        this.mBufferManager.load(samples);
        this.mResampler.process(this.mResampleFactor, (SampleBuffers)this.mBufferManager, lastBatch);
    }

    public void setListener(Listener<float[]> listener) {
        this.mResampledListener = listener;
    }

    public class BufferManager
    implements SampleBuffers {
        private int mOutputArrayLength;
        private FloatBuffer mInputBuffer;
        private FloatBuffer mOutputBuffer;

        public BufferManager(int bufferSize, int outputArrayLength) {
            this.mOutputArrayLength = outputArrayLength;
            this.mInputBuffer = ByteBuffer.allocate(bufferSize * 4).asFloatBuffer();
            this.mOutputBuffer = ByteBuffer.allocate(bufferSize * 4).asFloatBuffer();
        }

        public void load(float[] samples) {
            this.mInputBuffer.put(samples);
        }

        public int getInputBufferLength() {
            return this.mInputBuffer.position();
        }

        public int getOutputBufferLength() {
            return this.mOutputBuffer.remaining();
        }

        public void produceInput(float[] samples, int offset, int length) {
            this.mInputBuffer.flip();
            this.mInputBuffer.get(samples, offset, length);
            this.mInputBuffer.compact();
        }

        public void consumeOutput(float[] samples, int offset, int length) {
            this.mOutputBuffer.put(samples, offset, length);
            while (this.mOutputBuffer.position() > this.mOutputArrayLength) {
                float[] resampled = new float[this.mOutputArrayLength];
                this.mOutputBuffer.flip();
                this.mOutputBuffer.get(resampled);
                this.mOutputBuffer.compact();
                if (RealResampler.this.mResampledListener == null) continue;
                RealResampler.this.mResampledListener.receive(resampled);
            }
        }
    }
}

