/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.hilbert;

import io.github.dsheirer.dsp.filter.hilbert.HilbertTransform;
import io.github.dsheirer.sample.SampleUtils;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorHilbertTransformDefaultBits
extends HilbertTransform {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_PREFERRED;

    @Override
    public ComplexSamples filter(float[] realSamples, long timestamp) {
        int bufferLength = realSamples.length / 2;
        if (this.mIBuffer.length != bufferLength + this.mIOverlap) {
            float[] iTemp = new float[bufferLength + this.mIOverlap];
            float[] qTemp = new float[bufferLength + this.mQOverlap];
            System.arraycopy(this.mIBuffer, 0, iTemp, 0, this.mIOverlap);
            System.arraycopy(this.mQBuffer, 0, qTemp, 0, this.mQOverlap);
            this.mIBuffer = iTemp;
            this.mQBuffer = qTemp;
        }
        ComplexSamples deinterleaved = SampleUtils.deinterleave(realSamples, timestamp);
        VectorUtilities.checkComplexArrayLength(deinterleaved.i(), deinterleaved.q(), VECTOR_SPECIES);
        System.arraycopy(deinterleaved.i(), 0, this.mIBuffer, this.mIOverlap, deinterleaved.i().length);
        System.arraycopy(deinterleaved.q(), 0, this.mQBuffer, this.mQOverlap, deinterleaved.q().length);
        float[] i = new float[bufferLength];
        float[] q = new float[bufferLength];
        for (int x = 0; x < bufferLength; ++x) {
            FloatVector accumulator = FloatVector.zero(VECTOR_SPECIES);
            for (int y = 0; y < this.mCoefficients.length; y += VECTOR_SPECIES.length()) {
                FloatVector filter = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)y);
                FloatVector samples = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + y));
                accumulator = filter.fma((Vector)samples, (Vector)accumulator);
            }
            i[x] = this.mIBuffer[x];
            q[x] = accumulator.reduceLanes(VectorOperators.ADD);
        }
        System.arraycopy(this.mIBuffer, this.mIBuffer.length - this.mIOverlap, this.mIBuffer, 0, this.mIOverlap);
        System.arraycopy(this.mQBuffer, this.mQBuffer.length - this.mQOverlap, this.mQBuffer, 0, this.mQOverlap);
        return new ComplexSamples(i, q, timestamp);
    }
}

