/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.hilbert;

import io.github.dsheirer.dsp.filter.hilbert.HilbertTransform;
import io.github.dsheirer.sample.SampleUtils;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorHilbertTransform64Bits
extends HilbertTransform {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_64;

    @Override
    public ComplexSamples filter(float[] realSamples, long timestamp) {
        int bufferLength = realSamples.length / 2;
        if (this.mIBuffer.length != bufferLength + this.mIOverlap) {
            float[] iTemp = new float[bufferLength + this.mIOverlap];
            float[] qTemp = new float[bufferLength + this.mQOverlap];
            System.arraycopy(this.mIBuffer, 0, iTemp, 0, this.mIOverlap);
            System.arraycopy(this.mQBuffer, 0, qTemp, 0, this.mQOverlap);
            this.mIBuffer = iTemp;
            this.mQBuffer = qTemp;
        }
        ComplexSamples deinterleaved = SampleUtils.deinterleave(realSamples, timestamp);
        VectorUtilities.checkComplexArrayLength(deinterleaved.i(), deinterleaved.q(), VECTOR_SPECIES);
        System.arraycopy(deinterleaved.i(), 0, this.mIBuffer, this.mIOverlap, deinterleaved.i().length);
        System.arraycopy(deinterleaved.q(), 0, this.mQBuffer, this.mQOverlap, deinterleaved.q().length);
        float[] i = new float[bufferLength];
        float[] q = new float[bufferLength];
        FloatVector filterA = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)0);
        FloatVector filterB = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)2);
        FloatVector filterC = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)4);
        FloatVector filterD = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)6);
        FloatVector filterE = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)8);
        FloatVector filterF = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)10);
        FloatVector filterG = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)12);
        FloatVector filterH = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)14);
        FloatVector filterI = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)16);
        FloatVector filterJ = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)18);
        FloatVector filterK = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)20);
        FloatVector filterL = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)22);
        for (int x = 0; x < bufferLength; ++x) {
            FloatVector accumulator = FloatVector.zero(VECTOR_SPECIES);
            accumulator = filterA.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)x), (Vector)accumulator);
            accumulator = filterB.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 2)), (Vector)accumulator);
            accumulator = filterC.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 4)), (Vector)accumulator);
            accumulator = filterD.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 6)), (Vector)accumulator);
            accumulator = filterE.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 8)), (Vector)accumulator);
            accumulator = filterF.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 10)), (Vector)accumulator);
            accumulator = filterG.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 12)), (Vector)accumulator);
            accumulator = filterH.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 14)), (Vector)accumulator);
            accumulator = filterI.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 16)), (Vector)accumulator);
            accumulator = filterJ.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 18)), (Vector)accumulator);
            accumulator = filterK.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 20)), (Vector)accumulator);
            accumulator = filterL.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 22)), (Vector)accumulator);
            i[x] = this.mIBuffer[x];
            q[x] = accumulator.reduceLanes(VectorOperators.ADD);
        }
        System.arraycopy(this.mIBuffer, this.mIBuffer.length - this.mIOverlap, this.mIBuffer, 0, this.mIOverlap);
        System.arraycopy(this.mQBuffer, this.mQBuffer.length - this.mQOverlap, this.mQBuffer, 0, this.mQOverlap);
        return new ComplexSamples(i, q, timestamp);
    }
}

