/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.hilbert;

import io.github.dsheirer.dsp.filter.hilbert.HilbertTransform;
import io.github.dsheirer.dsp.filter.hilbert.ScalarHilbertTransform;
import io.github.dsheirer.dsp.filter.hilbert.VectorHilbertTransform128Bits;
import io.github.dsheirer.dsp.filter.hilbert.VectorHilbertTransform256Bits;
import io.github.dsheirer.dsp.filter.hilbert.VectorHilbertTransform512Bits;
import io.github.dsheirer.dsp.filter.hilbert.VectorHilbertTransform64Bits;
import io.github.dsheirer.dsp.filter.hilbert.VectorHilbertTransformDefaultBits;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;

public class HilbertTransformFactory {
    public static HilbertTransform getHilbertTransform() {
        Implementation implementation = CalibrationManager.getInstance().getImplementation(CalibrationType.HILBERT_TRANSFORM);
        switch (implementation) {
            case VECTOR_SIMD_PREFERRED: {
                return new VectorHilbertTransformDefaultBits();
            }
            case VECTOR_SIMD_64: {
                return new VectorHilbertTransform64Bits();
            }
            case VECTOR_SIMD_128: {
                return new VectorHilbertTransform128Bits();
            }
            case VECTOR_SIMD_256: {
                return new VectorHilbertTransform256Bits();
            }
            case VECTOR_SIMD_512: {
                return new VectorHilbertTransform512Bits();
            }
        }
        return new ScalarHilbertTransform();
    }
}

