/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.hilbert;

import io.github.dsheirer.sample.complex.ComplexSamples;
import org.apache.commons.math3.util.FastMath;

public abstract class HilbertTransform {
    public static final float[] HALF_BAND_FILTER_47_TAP = new float[]{-9.986063E-4f, 0.0f, 0.0016956372f, 0.0f, -0.0030544302f, 0.0f, 0.0050555044f, 0.0f, -0.007901319f, 0.0f, 0.011873357f, 0.0f, -0.01741116f, 0.0f, 0.025304817f, 0.0f, -0.037225224f, 0.0f, 0.057533287f, 0.0f, -0.10232746f, 0.0f, 0.31703448f, 0.5f, 0.31703448f, 0.0f, -0.10232746f, 0.0f, 0.057533287f, 0.0f, -0.037225224f, 0.0f, 0.025304817f, 0.0f, -0.01741116f, 0.0f, 0.011873357f, 0.0f, -0.007901319f, 0.0f, 0.0050555044f, 0.0f, -0.0030544302f, 0.0f, 0.0016956372f, 0.0f, -9.986063E-4f};
    protected float[] mCoefficients;
    protected int mIOverlap = 11;
    protected int mQOverlap = 23;
    protected float[] mIBuffer = new float[this.mIOverlap];
    protected float[] mQBuffer = new float[this.mQOverlap];

    public HilbertTransform() {
        this.mCoefficients = HilbertTransform.convertHalfBandToHilbert(HALF_BAND_FILTER_47_TAP);
    }

    public abstract ComplexSamples filter(float[] var1, long var2);

    public static float[] convertHalfBandToHilbert(float[] coefficients) {
        float[] hilbert = new float[coefficients.length / 2 + 1];
        int middle = coefficients.length / 2;
        for (int x = 0; x < coefficients.length; x += 2) {
            if (x < middle) {
                hilbert[x / 2] = -2.0f * FastMath.abs((float)coefficients[x]);
                continue;
            }
            if (x <= middle) continue;
            hilbert[x / 2] = 2.0f * FastMath.abs((float)coefficients[x]);
        }
        return hilbert;
    }
}

