/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.fir.remez;

import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.remez.FIRLinearPhaseFilterType;
import io.github.dsheirer.dsp.filter.fir.remez.PolyphaseChannelizerDesigner;
import io.github.dsheirer.dsp.filter.fir.remez.RemezFIRFilterDesignerWithLagrange;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyphaseChannelizerFilterFactory {
    private static final Logger mLog = LoggerFactory.getLogger(PolyphaseChannelizerFilterFactory.class);
    private static final double OBJECTIVE_BAND_EDGE_COEFFICIENT_AMPLITUDE = FastMath.sqrt((double)2.0) / 2.0;

    public static float[] getFilter(int sampleRate, int channelBandwidth, double alpha) {
        FIRLinearPhaseFilterType type = FIRLinearPhaseFilterType.TYPE_2_EVEN_LENGTH_ODD_ORDER_SYMMETRICAL;
        boolean passBandStart = false;
        int gridDensity = 60;
        int rolloffFrequency = (int)(alpha * (double)channelBandwidth);
        int passBandStop = channelBandwidth - rolloffFrequency;
        int stopBandStart = channelBandwidth + rolloffFrequency;
        double passRipple = 0.01;
        double transitionRipple = 0.02;
        double stopRipple = 0.001;
        int order = FIRFilterSpecification.estimateFilterOrder(sampleRate, passBandStop, stopBandStart, passRipple, stopRipple);
        if (order % 2 == 0) {
            ++order;
        }
        mLog.info("Filter Order: " + order);
        PolyphaseChannelizerDesigner specification = new PolyphaseChannelizerDesigner(order, gridDensity);
        FIRFilterSpecification.FrequencyBand passBand = new FIRFilterSpecification.FrequencyBand(sampleRate, (double)passBandStart, passBandStop, 1.0, passRipple, 1.0);
        FIRFilterSpecification.FrequencyBand transitionBand = new FIRFilterSpecification.FrequencyBand(sampleRate, channelBandwidth, channelBandwidth, OBJECTIVE_BAND_EDGE_COEFFICIENT_AMPLITUDE, transitionRipple, 5.0);
        FIRFilterSpecification.FrequencyBand stopBand = new FIRFilterSpecification.FrequencyBand(sampleRate, stopBandStart, sampleRate / 2, 0.0, stopRipple);
        specification.addFrequencyBand(passBand);
        specification.addFrequencyBand(transitionBand);
        specification.addFrequencyBand(stopBand);
        double bandEdgeFrequency = FastMath.cos((double)(Math.PI * (double)channelBandwidth / (double)(sampleRate / 2)));
        float[] filter = null;
        try {
            RemezFIRFilterDesignerWithLagrange designer = new RemezFIRFilterDesignerWithLagrange(specification);
            filter = designer.getImpulseResponse();
            double bandEdgeAmplitude = designer.getFrequencyResponse(bandEdgeFrequency);
            mLog.debug("Coefficient Amplitude at Band Edge is: " + bandEdgeAmplitude + " for frequency: " + passBandStop);
        }
        catch (Exception e) {
            mLog.error("Error designing filter", (Throwable)e);
        }
        return filter;
    }
}

