/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.fir.remez;

import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import org.apache.commons.math3.util.FastMath;

public class Grid {
    public static final double TWO_PI = Math.PI * 2;
    private double[] mFrequencyGrid;
    private double[] mCosineOfFrequencyGrid;
    private double[] mDesiredResponse;
    private double[] mWeight;

    public Grid(FIRFilterSpecification specification) {
        this.create(specification);
    }

    private void create(FIRFilterSpecification specification) {
        int gridSize = specification.getGridSize();
        this.mFrequencyGrid = new double[gridSize];
        this.mCosineOfFrequencyGrid = new double[gridSize];
        this.mDesiredResponse = new double[gridSize];
        this.mWeight = new double[gridSize];
        double gridFrequencyInterval = specification.getGridFrequencyInterval();
        double bandZeroEdge = specification.getFrequencyBands().get(0).getStart();
        double grid0 = specification.isAntiSymmetrical() && gridFrequencyInterval > bandZeroEdge ? gridFrequencyInterval : bandZeroEdge;
        int j = 0;
        double maxRipple = specification.getMaxBandAmplitude();
        for (int x = 0; x < specification.getFrequencyBands().size(); ++x) {
            FIRFilterSpecification.FrequencyBand band = specification.getFrequencyBands().get(x);
            double lowFrequency = x == 0 ? grid0 : band.getStart();
            for (int i = 0; i < band.getGridSize(); ++i) {
                this.mDesiredResponse[j] = band.getAmplitude();
                this.mWeight[j] = band.getWeight(maxRipple);
                this.mFrequencyGrid[j] = lowFrequency;
                this.mCosineOfFrequencyGrid[j] = FastMath.cos((double)(Math.PI * 2 * this.mFrequencyGrid[j]));
                lowFrequency += gridFrequencyInterval;
                ++j;
            }
            int lastIndex = j - 1;
            this.mFrequencyGrid[lastIndex] = band.getEnd();
        }
    }

    public int getSize() {
        return this.mFrequencyGrid.length;
    }

    public double[] getFrequencyGrid() {
        return this.mFrequencyGrid;
    }

    public double[] getCosineFrequencyGrid() {
        return this.mCosineOfFrequencyGrid;
    }

    public double[] getDesiredResponse() {
        return this.mDesiredResponse;
    }

    public double[] getWeight() {
        return this.mWeight;
    }
}

