/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.fir.real;

import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.apache.commons.lang3.ArrayUtils;

public class VectorRealFIRFilter512Bit
implements IRealFilter {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_512;
    private float[] mBuffer;
    private float[] mCoefficients;
    private int mBufferOverlap;

    public VectorRealFIRFilter512Bit(float[] coefficients) {
        int arrayLength;
        VectorUtilities.checkSpecies(VECTOR_SPECIES);
        for (arrayLength = VECTOR_SPECIES.length(); arrayLength < coefficients.length; arrayLength += VECTOR_SPECIES.length()) {
        }
        ArrayUtils.reverse((float[])coefficients);
        this.mCoefficients = new float[arrayLength];
        System.arraycopy(coefficients, 0, this.mCoefficients, 0, coefficients.length);
        this.mBufferOverlap = Math.max(arrayLength - 1, coefficients.length - 1);
        this.mBuffer = new float[arrayLength];
    }

    @Override
    public float[] filter(float[] samples) {
        int bufferLength = samples.length + this.mBufferOverlap;
        if (this.mBuffer.length != bufferLength) {
            float[] temp = new float[bufferLength];
            System.arraycopy(this.mBuffer, this.mBuffer.length - this.mBufferOverlap, temp, 0, this.mBufferOverlap);
            this.mBuffer = temp;
        } else {
            System.arraycopy(this.mBuffer, samples.length, this.mBuffer, 0, this.mBufferOverlap);
        }
        System.arraycopy(samples, 0, this.mBuffer, this.mBufferOverlap, samples.length);
        float[] filtered = new float[samples.length];
        for (int bufferPointer = 0; bufferPointer < samples.length; ++bufferPointer) {
            FloatVector accumulator = FloatVector.zero(VECTOR_SPECIES);
            for (int coefficientPointer = 0; coefficientPointer < this.mCoefficients.length; coefficientPointer += VECTOR_SPECIES.length()) {
                FloatVector filter = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)coefficientPointer);
                FloatVector buffer = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + coefficientPointer));
                accumulator = filter.fma((Vector)buffer, (Vector)accumulator);
            }
            filtered[bufferPointer] = accumulator.reduceLanes(VectorOperators.ADD);
        }
        return filtered;
    }
}

