/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.fir.complex;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.fir.complex.IComplexFilter;
import io.github.dsheirer.dsp.filter.fir.complex.VectorComplexFIRFilter128Bit;
import io.github.dsheirer.dsp.window.WindowType;
import java.text.DecimalFormat;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;

public class ScalarComplexFIRFilter
implements IComplexFilter {
    private float[] mBuffer;
    private float[] mCoefficients;
    private int mBufferOverlap;

    public ScalarComplexFIRFilter(float[] coefficients) {
        ArrayUtils.reverse((float[])coefficients);
        this.mCoefficients = new float[coefficients.length * 2];
        for (int x = 0; x < coefficients.length; ++x) {
            this.mCoefficients[2 * x] = coefficients[x];
        }
        this.mBufferOverlap = this.mCoefficients.length - 2;
        this.mBuffer = new float[this.mCoefficients.length];
    }

    @Override
    public float[] filter(float[] samples) {
        int bufferLength = samples.length + this.mBufferOverlap;
        if (this.mBuffer.length != bufferLength) {
            float[] temp = new float[bufferLength];
            System.arraycopy(this.mBuffer, this.mBuffer.length - this.mBufferOverlap, temp, 0, this.mBufferOverlap);
            this.mBuffer = temp;
        } else {
            System.arraycopy(this.mBuffer, samples.length, this.mBuffer, 0, this.mBufferOverlap);
        }
        System.arraycopy(samples, 0, this.mBuffer, this.mBufferOverlap, samples.length);
        float[] filtered = new float[samples.length];
        int offset = 0;
        for (int bufferPointer = 0; bufferPointer < samples.length; bufferPointer += 2) {
            float iAccumulator = 0.0f;
            float qAccumulator = 0.0f;
            for (int coefficientPointer = 0; coefficientPointer < this.mCoefficients.length; coefficientPointer += 2) {
                offset = bufferPointer + coefficientPointer;
                iAccumulator += this.mBuffer[offset] * this.mCoefficients[coefficientPointer];
                qAccumulator += this.mBuffer[offset + 1] * this.mCoefficients[coefficientPointer];
            }
            filtered[bufferPointer] = iAccumulator;
            filtered[bufferPointer + 1] = qAccumulator;
        }
        return filtered;
    }

    public static void main(String[] args) {
        Random random = new Random();
        int sampleSize = 2048;
        float[] samples = new float[sampleSize];
        for (int x = 0; x < samples.length; ++x) {
            samples[x] = random.nextFloat() * 2.0f - 1.0f;
        }
        float[] coefficients = FilterFactory.getLowPass(1000.0, 250L, 99, WindowType.BLACKMAN);
        ScalarComplexFIRFilter filter = new ScalarComplexFIRFilter(coefficients);
        VectorComplexFIRFilter128Bit vectorFilter = new VectorComplexFIRFilter128Bit(coefficients);
        double accumulator = 0.0;
        int iterations = 1000000;
        long start = System.currentTimeMillis();
        for (int x = 0; x < iterations; ++x) {
            float[] filtered = vectorFilter.filter(samples);
            accumulator += (double)filtered[3];
        }
        double elapsed = System.currentTimeMillis() - start;
        DecimalFormat df = new DecimalFormat("0.000");
        System.out.println("Accumulator: " + accumulator);
        System.out.println("Test Complete.  Elapsed Time: " + df.format(elapsed / 1000.0) + " seconds");
    }
}

