/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.equalizer;

import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.Complex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMAEqualizer
implements Listener<Complex> {
    private static final Logger mLog = LoggerFactory.getLogger(CMAEqualizer.class);
    public static final int TAP_COUNT = 11;
    private float mModulus;
    private float mMu;
    private Complex mError = new Complex(0.0f, 0.0f);
    private Complex[] mTaps = new Complex[11];
    private Complex[] mBuffer = new Complex[11];
    private int mBufferPointer = 0;
    private Listener<Complex> mListener;

    public CMAEqualizer(float modulus, float mu) {
        this.mModulus = modulus;
        this.mMu = mu;
        this.mTaps[0] = new Complex(1.0f, 0.0f);
        for (int x = 1; x < 11; ++x) {
            this.mTaps[x] = new Complex(0.0f, 0.0f);
            this.mBuffer[x] = new Complex(0.0f, 0.0f);
        }
    }

    private void updateTaps(Complex sample) {
        this.mError = Complex.multiply(sample, sample.norm() - this.mModulus);
        this.mError.clip(1.0f);
        for (int x = 0; x < 11; ++x) {
            this.mTaps[x] = Complex.subtract(this.mTaps[x], Complex.multiply(Complex.multiply(this.mBuffer[x].conjugate(), this.mError), this.mMu));
        }
    }

    @Override
    public void receive(Complex sample) {
        this.mBuffer[this.mBufferPointer] = sample;
        ++this.mBufferPointer;
        this.mBufferPointer %= 11;
        Complex equalized = this.filter();
        this.updateTaps(equalized);
        if (this.mListener != null) {
            this.mListener.receive(equalized);
        }
        mLog.debug("Tap 0:" + this.mTaps[0].toString() + " error:" + this.mError.toString());
    }

    private Complex filter() {
        Complex sum = new Complex(0.0f, 0.0f);
        for (int x = 0; x < 11; ++x) {
            sum = Complex.add(sum, Complex.multiply(this.mBuffer[(x + this.mBufferPointer) % 11], this.mTaps[11 - x - 1]));
        }
        return sum;
    }

    public void setListener(Listener<Complex> listener) {
        this.mListener = listener;
    }
}

