/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.design;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.window.WindowType;
import java.text.DecimalFormat;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.fft.FloatFFT_1D;

public class HalfBandDecimationFilterAnalysis {
    private static final int FFT_SIZE = 4096;
    private static FloatFFT_1D FFT = new FloatFFT_1D(4096L);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
    private static final WindowType WINDOW_TYPE = WindowType.BLACKMAN;
    private static final int[] TAP_LENGTHS = new int[]{7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63, 67, 71, 75, 79, 83, 87, 91, 95, 99, 103, 107};
    private static final int BY_2 = 1024;
    private static final int BY_2_25 = 910;
    private static final int BY_2_50 = 819;
    private static final int BY_2_75 = 744;
    private static final int BY_3 = 682;
    private static final int BY_4 = 512;
    private static final int BY_8 = 256;
    private static final int BY_16 = 128;
    private static final int BY_32 = 64;
    private static final int BY_64 = 32;
    private static final int BY_128 = 16;
    private static final int BY_256 = 8;
    private static final int BY_512 = 4;
    private static final int BY_1024 = 2;

    public static void analyze() {
        for (WindowType windowType : WindowType.NO_PARAMETER_WINDOWS) {
            StringBuilder sb = new StringBuilder();
            sb.append("Window: " + String.valueOf((Object)windowType)).append("\n");
            sb.append("Length\t\t2x\t\t2.25x\t2.50x\t2.75x\t3x\t\t4x\t\t8x\t\t16x\t\t32x\t\t64x\t\t128x\t256x\t512x\t1024x\n");
            for (int length : TAP_LENGTHS) {
                float[] taps = HalfBandDecimationFilterAnalysis.getTaps(length, windowType);
                float[] dft = HalfBandDecimationFilterAnalysis.getDFT(taps);
                float[] decibels = HalfBandDecimationFilterAnalysis.convertDFTToDecibel(dft, 2048);
                float x2Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(1024, decibels);
                float x225Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(910, decibels);
                float x250Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(819, decibels);
                float x275Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(744, decibels);
                float x3Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(682, decibels);
                float x4Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(512, decibels);
                float x8Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(256, decibels);
                float x16Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(128, decibels);
                float x32Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(64, decibels);
                float x64Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(32, decibels);
                float x128Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(16, decibels);
                float x256Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(8, decibels);
                float x512Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(4, decibels);
                float x1024Cutoff = HalfBandDecimationFilterAnalysis.getCutoff(2, decibels);
                sb.append(length).append("\t\t\t");
                sb.append(DECIMAL_FORMAT.format(x2Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x225Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x250Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x275Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x3Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x4Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x8Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x16Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x32Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x64Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x128Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x256Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x512Cutoff)).append("\t");
                sb.append(DECIMAL_FORMAT.format(x1024Cutoff)).append("\n");
            }
            System.out.println(sb.toString());
        }
    }

    private static float getCutoff(int index, float[] decibels) {
        int startIndex;
        float cutoff = -200.0f;
        for (int x = startIndex = decibels.length - index; x < decibels.length; ++x) {
            if (!(decibels[x] > cutoff)) continue;
            cutoff = decibels[x];
        }
        return cutoff;
    }

    private static float[] getTaps(int filterLength, WindowType windowType) {
        return FilterFactory.getHalfBand(filterLength, windowType);
    }

    private static float[] getDFT(float[] taps) {
        float[] dft = new float[4096];
        System.arraycopy(taps, 0, dft, 0, taps.length);
        FFT.realForward(dft);
        return dft;
    }

    public static float[] convertDFTToDecibel(float[] dft, int tapLength) {
        float[] decibels = new float[dft.length / 2];
        int index = 0;
        for (int x = 0; x < decibels.length; ++x) {
            index = x * 2;
            decibels[x] = 20.0f * (float)FastMath.log10((double)(dft[index] * dft[index] + dft[index + 1] * dft[index + 1]));
        }
        return decibels;
    }

    public static void main(String[] args) {
        HalfBandDecimationFilterAnalysis.analyze();
    }
}

