/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.design;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.design.FilterView;
import io.github.dsheirer.dsp.filter.hilbert.HilbertTransform;
import io.github.dsheirer.dsp.window.WindowType;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterViewer
extends Application {
    private static final Logger mLog = LoggerFactory.getLogger(FilterViewer.class);

    public void start(Stage primaryStage) throws Exception {
        Scene scene = new Scene((Parent)new FilterView(this.getFilter()));
        primaryStage.setTitle("Filter Viewer");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public static void main(String[] args) {
        FilterViewer.launch((String[])args);
    }

    private float[] getFilter() {
        int filterLength = 47;
        WindowType windowType = WindowType.HAMMING;
        float[] taps = FilterFactory.getHalfBand(filterLength, windowType);
        taps = HilbertTransform.HALF_BAND_FILTER_47_TAP;
        if (taps == null) {
            throw new IllegalStateException("Couldn't design filter");
        }
        return taps;
    }
}

