/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.cic;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.filter.fir.remez.RemezFIRFilterDesigner;
import io.github.dsheirer.dsp.oscillator.IRealOscillator;
import io.github.dsheirer.dsp.oscillator.OscillatorFactory;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.primes.Primes;

public class PrimeCicDecimationFilter {
    private Stage mFirstStage;

    public PrimeCicDecimationFilter(double sampleRate, int decimation, double passFrequency, double stopFrequency) throws FilterDesignException {
        List stageSizes = Primes.primeFactors((int)decimation);
        DecimatingStage stage = null;
        for (int x = 0; x < stageSizes.size(); ++x) {
            DecimatingStage nextStage = new DecimatingStage(this, (Integer)stageSizes.get(x), 1);
            if (stage != null) {
                ((Stage)stage).setChild(nextStage);
            }
            stage = nextStage;
            if (x != 0) continue;
            this.mFirstStage = stage;
        }
        if (stage != null) {
            double channelRate = sampleRate / (double)decimation;
            Output output = new Output(this, channelRate, passFrequency, stopFrequency);
            ((Stage)stage).setChild(output);
        }
    }

    public float[] decimate(float[] samples) {
        return this.mFirstStage.process(samples);
    }

    public static void main(String[] args) {
        double sampleRate = 25.0;
        int decimation = 5;
        double finalRate = sampleRate / (double)decimation;
        IRealOscillator oscillator = OscillatorFactory.getRealOscillator(1.0, sampleRate);
        try {
            PrimeCicDecimationFilter filter = new PrimeCicDecimationFilter(sampleRate, decimation, 1.5, 2.0);
            for (int x = 0; x < 20; ++x) {
                float[] samples = oscillator.generate(5000);
                float[] decimated = filter.decimate(samples);
                System.out.println(Arrays.toString(decimated));
            }
        }
        catch (FilterDesignException fde) {
            fde.printStackTrace();
        }
    }

    public class DecimatingStage
    extends Stage {
        private Stage mFirstStage;
        private Stage mDecimator;

        public DecimatingStage(PrimeCicDecimationFilter this$0, int size, int order) {
            super(this$0);
            NoDecimateStage stage = null;
            for (int x = 0; x < order; ++x) {
                NoDecimateStage nextStage = size == 2 ? new NoDecimateTwoStage(this$0) : new NoDecimateStage(this$0, size);
                if (stage != null) {
                    stage.setChild(nextStage);
                }
                stage = nextStage;
                if (x != 0) continue;
                this.mFirstStage = stage;
            }
            this.mDecimator = new Decimator(this$0, size);
            if (stage != null) {
                stage.setChild(this.mDecimator);
            }
        }

        @Override
        public float[] process(float[] samples) {
            if (this.hasChild()) {
                return this.getChild().process(this.mFirstStage.process(samples));
            }
            return this.mFirstStage.process(samples);
        }

        @Override
        public void setChild(Stage stage) {
            this.mDecimator.setChild(stage);
        }
    }

    public abstract class Stage {
        private Stage mChild;

        public Stage(PrimeCicDecimationFilter this$0) {
        }

        public void setChild(Stage stage) {
            this.mChild = stage;
        }

        protected boolean hasChild() {
            return this.mChild != null;
        }

        protected Stage getChild() {
            return this.mChild;
        }

        public abstract float[] process(float[] var1);
    }

    public class Output
    extends Stage {
        private IRealFilter mFilter;

        public Output(PrimeCicDecimationFilter this$0, double outputSampleRate, double passFrequency, double stopFrequency) throws FilterDesignException {
            super(this$0);
            float[] coefficients = this.getLowPassFilter(outputSampleRate, passFrequency, stopFrequency);
            this.mFilter = FilterFactory.getRealFilter(coefficients);
        }

        @Override
        public float[] process(float[] samples) {
            if (this.hasChild()) {
                return this.getChild().process(this.mFilter.filter(samples));
            }
            return this.mFilter.filter(samples);
        }

        private float[] getLowPassFilter(double sampleRate, double passFrequency, double stopFrequency) throws FilterDesignException {
            FIRFilterSpecification specification = FIRFilterSpecification.lowPassBuilder().sampleRate(sampleRate).gridDensity(16).passBandCutoff(passFrequency).passBandAmplitude(1.0).passBandRipple(0.01).stopBandStart(stopFrequency).stopBandAmplitude(0.0).stopBandRipple(0.01).build();
            RemezFIRFilterDesigner designer = new RemezFIRFilterDesigner(specification);
            return designer.getImpulseResponse();
        }
    }

    public class NoDecimateTwoStage
    extends NoDecimateStage {
        public NoDecimateTwoStage(PrimeCicDecimationFilter this$0) {
            super(this$0, 0.5f);
        }

        @Override
        public float[] process(float[] samples) {
            float previousSample = this.mSum;
            for (int x = 0; x < samples.length; ++x) {
                float temp = (previousSample + samples[x]) * 0.5f;
                previousSample = samples[x];
                samples[x] = temp;
            }
            this.mSum = previousSample;
            if (this.hasChild()) {
                return this.getChild().process(samples);
            }
            return samples;
        }
    }

    public class NoDecimateStage
    extends Stage {
        private float[] mSampleBuffer;
        private int mSamplePointer = 0;
        private int mSize;
        protected float mSum;
        protected float mGain;

        public NoDecimateStage(PrimeCicDecimationFilter this$0, int size) {
            super(this$0);
            this.mSize = size - 1;
            this.mSampleBuffer = new float[this.mSize];
            float baseGain = 1.0f / (float)size;
            this.mGain = baseGain * (1.0f / (1.0f - baseGain));
        }

        protected NoDecimateStage(PrimeCicDecimationFilter this$0, float gain) {
            super(this$0);
            this.mGain = gain;
        }

        @Override
        public float[] process(float[] samples) {
            float sum = this.mSum;
            float gain = this.mGain;
            float size = this.mSize;
            int pointer = this.mSamplePointer;
            for (int x = 0; x < samples.length; ++x) {
                this.mSampleBuffer[pointer] = samples[x];
                ++pointer;
                pointer = (int)((float)pointer % size);
                samples[x] = (sum -= this.mSampleBuffer[pointer] + samples[x]) * gain;
            }
            this.mSum = sum;
            this.mSamplePointer = pointer;
            if (this.hasChild()) {
                return this.getChild().process(samples);
            }
            return samples;
        }
    }

    public class Decimator
    extends Stage {
        private float[] mResidual;
        private int mDecimationFactor;

        public Decimator(PrimeCicDecimationFilter this$0, int decimationFactor) {
            super(this$0);
            this.mDecimationFactor = decimationFactor;
        }

        @Override
        public float[] process(float[] samples) {
            if (this.mResidual != null) {
                float[] expanded = new float[this.mResidual.length + samples.length];
                System.arraycopy(this.mResidual, 0, expanded, 0, this.mResidual.length);
                System.arraycopy(samples, 0, expanded, this.mResidual.length, samples.length);
                samples = expanded;
                this.mResidual = null;
            }
            float[] decimated = new float[samples.length / this.mDecimationFactor];
            for (int x = 0; x < decimated.length; ++x) {
                decimated[x] = samples[x * this.mDecimationFactor];
            }
            int residual = samples.length % this.mDecimationFactor;
            if (residual > 0) {
                this.mResidual = Arrays.copyOfRange(samples, samples.length - residual, samples.length);
            }
            if (this.hasChild()) {
                return this.getChild().process(decimated);
            }
            return decimated;
        }
    }
}

