/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer.output;

import io.github.dsheirer.dsp.filter.channelizer.output.ChannelOutputProcessor;
import io.github.dsheirer.dsp.filter.channelizer.output.OneChannelMixerAssembler;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.heartbeat.HeartbeatManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneChannelOutputProcessor
extends ChannelOutputProcessor {
    private static final Logger mLog = LoggerFactory.getLogger(OneChannelOutputProcessor.class);
    private final OneChannelMixerAssembler mMixerAssembler;
    private int mChannelOffset;

    public OneChannelOutputProcessor(double sampleRate, List<Integer> channelIndexes, float gain, HeartbeatManager heartbeatManager) {
        super(1, sampleRate, heartbeatManager);
        this.setPolyphaseChannelIndices(channelIndexes);
        this.mMixerAssembler = new OneChannelMixerAssembler(gain);
        this.mMixerAssembler.getMixer().setSampleRate(sampleRate);
    }

    @Override
    public String getStateDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("One Channel Output Processor");
        sb.append("\n\tIndex (doubled) [").append(this.mChannelOffset).append("]");
        sb.append("\n\tMixer Assembler: none");
        return sb.toString();
    }

    @Override
    public void setSynthesisFilter(float[] filter) {
        throw new IllegalArgumentException("The one channel output processor does not support filter updates");
    }

    @Override
    public void setPolyphaseChannelIndices(List<Integer> indexes) {
        if (indexes.size() != 1) {
            throw new IllegalArgumentException("Single channel output processor requires a single index to process - provided indexes " + String.valueOf(indexes));
        }
        this.mChannelOffset = indexes.get(0) * 2;
    }

    @Override
    public void setFrequencyOffset(long frequency) {
        this.mMixerAssembler.getMixer().setFrequency(frequency);
    }

    @Override
    public void process(List<float[]> channelResultsList) {
        for (float[] channelResults : channelResultsList) {
            this.mMixerAssembler.receive(channelResults[this.mChannelOffset], channelResults[this.mChannelOffset + 1]);
            if (!this.mMixerAssembler.hasBuffer()) continue;
            ComplexSamples buffer = this.mMixerAssembler.getBuffer(this.getCurrentSampleTimestamp());
            if (this.mComplexSamplesListener == null) continue;
            try {
                this.mComplexSamplesListener.receive(buffer);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception e) {
                mLog.error("Error extracting channel samples from one polyphase channel results buffer", (Throwable)e);
            }
        }
    }
}

