/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer.output;

import io.github.dsheirer.dsp.filter.channelizer.output.IPolyphaseChannelOutputProcessor;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.heartbeat.HeartbeatManager;
import io.github.dsheirer.util.Dispatcher;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelOutputProcessor
implements IPolyphaseChannelOutputProcessor {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelOutputProcessor.class);
    private Dispatcher<List<float[]>> mChannelResultsDispatcher;
    private HeartbeatManager mHeartbeatManager;
    protected Listener<ComplexSamples> mComplexSamplesListener;
    private int mInputChannelCount;
    private long mCurrentSampleTimestamp = System.currentTimeMillis();

    public ChannelOutputProcessor(int inputChannelCount, double sampleRate, HeartbeatManager heartbeatManager) {
        this.mInputChannelCount = inputChannelCount;
        this.mHeartbeatManager = heartbeatManager;
        this.mChannelResultsDispatcher = new Dispatcher("sdrtrunk polyphase channel", 50L, this.mHeartbeatManager);
        this.mChannelResultsDispatcher.setListener((E floats) -> {
            try {
                this.process((List<float[]>)floats);
            }
            catch (Throwable t) {
                mLog.error("Error processing channel results", t);
            }
        });
    }

    protected long getCurrentSampleTimestamp() {
        return this.mCurrentSampleTimestamp;
    }

    @Override
    public void start() {
        this.mChannelResultsDispatcher.start();
    }

    @Override
    public void stop() {
        this.mChannelResultsDispatcher.stop();
    }

    @Override
    public void setListener(Listener<ComplexSamples> listener) {
        this.mComplexSamplesListener = listener;
    }

    @Override
    public int getPolyphaseChannelIndexCount() {
        return this.mInputChannelCount;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void receiveChannelResults(List<float[]> channelResultsList, long timestamp) {
        this.mChannelResultsDispatcher.receive(channelResultsList);
        this.mCurrentSampleTimestamp = timestamp;
    }

    public abstract void process(List<float[]> var1);

    @Override
    public int getInputChannelCount() {
        return this.mInputChannelCount;
    }
}

