/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer;

import io.github.dsheirer.sample.complex.ComplexSamples;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.fft.FloatFFT_1D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoChannelSynthesizerM2 {
    private static final Logger mLog = LoggerFactory.getLogger(TwoChannelSynthesizerM2.class);
    private float[] mSerpentineDataBuffer;
    private float[] mIQInterleavedFilter;
    private float[] mFilterVectorProduct;
    private float mIAccumulator;
    private float mQAccumulator;
    private FloatFFT_1D mFFT = new FloatFFT_1D(2L);
    private boolean mTopBlockFlag = true;

    public TwoChannelSynthesizerM2(float[] filter) {
        this.init(filter);
    }

    public String getStateDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Two-Channel Synthesizer");
        sb.append("\n\t\t Interleaved Filter: " + Arrays.toString(this.mIQInterleavedFilter));
        sb.append("\n\t\t Serpentine Buffer Length: ").append(this.mSerpentineDataBuffer.length);
        sb.append("\n\t\t Filter Vector Product Length: ").append(this.mFilterVectorProduct.length);
        return sb.toString();
    }

    private void init(float[] filter) {
        int tapsPerChannel = (int)FastMath.ceil((double)(filter.length / 2));
        this.mIQInterleavedFilter = TwoChannelSynthesizerM2.getInterleavedFilter(filter, tapsPerChannel);
        this.mSerpentineDataBuffer = new float[this.mIQInterleavedFilter.length];
        this.mFilterVectorProduct = new float[this.mIQInterleavedFilter.length];
    }

    public ComplexSamples process(ComplexSamples channelBuffer1, ComplexSamples channelBuffer2) {
        if (channelBuffer1.i().length != channelBuffer1.i().length) {
            throw new IllegalArgumentException("Channel 1 and 2 array length must be equal");
        }
        float[] iCh1 = channelBuffer1.i();
        float[] qCh1 = channelBuffer1.q();
        float[] iCh2 = channelBuffer2.i();
        float[] qCh2 = channelBuffer2.q();
        float[] i = new float[iCh1.length];
        float[] q = new float[qCh1.length];
        float[] IFFTBuffer = new float[4];
        for (int x = 0; x < iCh1.length; ++x) {
            int y;
            IFFTBuffer[0] = iCh1[x];
            IFFTBuffer[1] = qCh1[x];
            IFFTBuffer[2] = iCh2[x];
            IFFTBuffer[3] = qCh2[x];
            this.mFFT.complexInverse(IFFTBuffer, true);
            System.arraycopy(this.mSerpentineDataBuffer, 0, this.mSerpentineDataBuffer, 4, this.mSerpentineDataBuffer.length - 4);
            if (this.mTopBlockFlag) {
                System.arraycopy(IFFTBuffer, 0, this.mSerpentineDataBuffer, 0, IFFTBuffer.length);
            } else {
                System.arraycopy(IFFTBuffer, 0, this.mSerpentineDataBuffer, 2, 2);
                System.arraycopy(IFFTBuffer, 2, this.mSerpentineDataBuffer, 0, 2);
            }
            for (y = 0; y < this.mSerpentineDataBuffer.length; ++y) {
                this.mFilterVectorProduct[y] = this.mSerpentineDataBuffer[y] * this.mIQInterleavedFilter[y];
            }
            this.mIAccumulator = 0.0f;
            this.mQAccumulator = 0.0f;
            for (y = 0; y < this.mFilterVectorProduct.length; y += 2) {
                this.mIAccumulator += this.mFilterVectorProduct[y];
                this.mQAccumulator += this.mFilterVectorProduct[y + 1];
            }
            i[x] = this.mIAccumulator;
            q[x] = this.mQAccumulator;
            this.mTopBlockFlag = !this.mTopBlockFlag;
        }
        return new ComplexSamples(i, q, channelBuffer1.timestamp());
    }

    private static float[] getInterleavedFilter(float[] coefficients, int tapsPerChannel) {
        int channelCount = 2;
        float[] filter = new float[channelCount * tapsPerChannel * 2];
        int coefficientPointer = 0;
        int filterPointer = 0;
        while (coefficientPointer < coefficients.length) {
            filter[filterPointer++] = coefficients[coefficientPointer];
            filter[filterPointer++] = coefficients[coefficientPointer++];
        }
        return filter;
    }
}

