/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer;

public class SampleTimestampManager {
    private long mReferenceTimestamp = System.currentTimeMillis();
    private double mSamplesPerMilliSecond;
    private long mSampleCount;

    public SampleTimestampManager(double sampleRate) {
        this.setSampleRate(sampleRate);
    }

    public void setReferenceTimestamp(long referenceTimestamp) {
        this.mReferenceTimestamp = referenceTimestamp;
        this.mSampleCount = 0L;
    }

    public void setSampleRate(double sampleRate) {
        this.mSamplesPerMilliSecond = sampleRate / 1000.0;
    }

    public void increment() {
        ++this.mSampleCount;
    }

    public void increment(int value) {
        this.mSampleCount += (long)value;
    }

    public long getCurrentTimestamp() {
        if (this.mSampleCount > 0L) {
            return this.mReferenceTimestamp + (long)((double)this.mSampleCount / this.mSamplesPerMilliSecond);
        }
        return this.mReferenceTimestamp;
    }
}

