/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.buffer.INativeBufferProvider;
import io.github.dsheirer.controller.channel.event.ChannelStopProcessingRequest;
import io.github.dsheirer.dsp.filter.channelizer.ChannelCalculator;
import io.github.dsheirer.dsp.filter.channelizer.ComplexPolyphaseChannelizerM2;
import io.github.dsheirer.dsp.filter.channelizer.PolyphaseChannelSource;
import io.github.dsheirer.dsp.filter.channelizer.SynthesisFilterManager;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.log.LoggingSuppressor;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.Source;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.util.Dispatcher;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyphaseChannelManager
implements ISourceEventProcessor {
    private static final DecimalFormat FREQUENCY_FORMAT = new DecimalFormat("0.00000");
    private static final LoggingSuppressor LOGGING_SUPPRESSOR = new LoggingSuppressor(LoggerFactory.getLogger(PolyphaseChannelManager.class));
    private static final Logger mLog = LoggerFactory.getLogger(PolyphaseChannelManager.class);
    private static final double MINIMUM_CHANNEL_BANDWIDTH = 25000.0;
    private static final double CHANNEL_OVERSAMPLING = 2.0;
    private static final int POLYPHASE_CHANNELIZER_TAPS_PER_CHANNEL = 9;
    private Broadcaster<SourceEvent> mSourceEventBroadcaster = new Broadcaster();
    private INativeBufferProvider mNativeBufferProvider;
    private List<PolyphaseChannelSource> mChannelSources = new CopyOnWriteArrayList<PolyphaseChannelSource>();
    private ChannelCalculator mChannelCalculator;
    private SynthesisFilterManager mFilterManager = new SynthesisFilterManager();
    private ComplexPolyphaseChannelizerM2 mPolyphaseChannelizer;
    private ChannelSourceEventListener mChannelSourceEventListener = new ChannelSourceEventListener();
    private NativeBufferReceiver mNativeBufferReceiver = new NativeBufferReceiver();
    private Dispatcher mBufferDispatcher;
    private Map<Integer, float[]> mOutputProcessorFilters = new HashMap<Integer, float[]>();
    private boolean mRunning = true;

    public PolyphaseChannelManager(INativeBufferProvider nativeBufferProvider, long frequency, double sampleRate) {
        if (nativeBufferProvider == null) {
            throw new IllegalArgumentException("Complex buffer provider argument cannot be null");
        }
        this.mNativeBufferProvider = nativeBufferProvider;
        int channelCount = (int)(sampleRate / 25000.0);
        if (channelCount % 2 != 0) {
            --channelCount;
        }
        this.mChannelCalculator = new ChannelCalculator(sampleRate, channelCount, frequency, 2.0);
        this.mBufferDispatcher = new Dispatcher("sdrtrunk polyphase buffer processor", 10L);
        this.mBufferDispatcher.setListener(this.mNativeBufferReceiver);
    }

    public PolyphaseChannelManager(TunerController tunerController) {
        this(tunerController, tunerController.getFrequency(), tunerController.getSampleRate());
    }

    public String getStateDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polyphase Channel Manager Providing [").append(this.mChannelSources.size()).append("] Channels");
        sb.append("\n\t").append(this.mChannelCalculator);
        for (PolyphaseChannelSource pcs : this.mChannelSources) {
            List<Integer> indexes = pcs.getOutputProcessorIndexes();
            double sampleRate = pcs.getSampleRate();
            long indexCenterFrequency = pcs.getIndexCenterFrequency();
            long appliedFrequencyOffset = pcs.getFrequencyOffset();
            long requestedCenterFrequency = pcs.getFrequency();
            sb.append("\n\tPolyphase | Tuner SR:").append(FREQUENCY_FORMAT.format(pcs.getTunerSampleRate() / 1000000.0));
            sb.append(" CF:").append(FREQUENCY_FORMAT.format(pcs.getTunerCenterFrequency() / 1000000.0));
            sb.append(" BW: ").append(FREQUENCY_FORMAT.format(sampleRate / 1000000.0));
            sb.append(" | Channel CF: ").append(FREQUENCY_FORMAT.format((double)indexCenterFrequency / 1000000.0));
            sb.append(" REQUESTED CF: ").append(FREQUENCY_FORMAT.format((double)requestedCenterFrequency / 1000000.0));
            sb.append(" MIXER:").append(FREQUENCY_FORMAT.format((double)appliedFrequencyOffset / 1000000.0));
            sb.append(" | Polyphase Indices: ").append(indexes);
        }
        return sb.toString();
    }

    public void stopAllChannels() {
        this.mRunning = false;
        ArrayList<PolyphaseChannelSource> toStop = new ArrayList<PolyphaseChannelSource>(this.mChannelSources);
        for (TunerChannelSource tunerChannelSource : toStop) {
            MyEventBus.getGlobalEventBus().post((Object)new ChannelStopProcessingRequest(tunerChannelSource));
        }
    }

    public void setErrorMessage(String errorMessage) {
        for (TunerChannelSource tunerChannelSource : this.mChannelSources) {
            tunerChannelSource.setError(errorMessage);
        }
    }

    public double getChannelBandwidth() {
        return this.mChannelCalculator.getChannelBandwidth();
    }

    public TunerChannelSource getChannel(TunerChannel tunerChannel) {
        PolyphaseChannelSource channelSource = null;
        if (this.mRunning) {
            try {
                channelSource = new PolyphaseChannelSource(tunerChannel, this.mChannelCalculator, this.mFilterManager, this.mChannelSourceEventListener);
                this.mChannelSources.add(channelSource);
            }
            catch (IllegalArgumentException iae) {
                LOGGING_SUPPRESSOR.error(iae.getMessage(), 3, "Couldn't allocate channel. " + iae.getMessage());
                channelSource = null;
            }
        }
        return channelSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startChannelSource(PolyphaseChannelSource channelSource) {
        Dispatcher dispatcher = this.mBufferDispatcher;
        synchronized (dispatcher) {
            this.checkChannelizerConfiguration();
            this.mPolyphaseChannelizer.addChannel(channelSource);
            this.mSourceEventBroadcaster.broadcast(SourceEvent.channelCountChange(this.getTunerChannelCount()));
            if (this.mPolyphaseChannelizer.getRegisteredChannelCount() == 1) {
                this.mNativeBufferProvider.addBufferListener(this.mBufferDispatcher);
                this.mPolyphaseChannelizer.start();
                this.mBufferDispatcher.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopChannelSource(PolyphaseChannelSource channelSource) {
        Dispatcher dispatcher = this.mBufferDispatcher;
        synchronized (dispatcher) {
            this.mChannelSources.remove(channelSource);
            this.mPolyphaseChannelizer.removeChannel(channelSource);
            this.mSourceEventBroadcaster.broadcast(SourceEvent.channelCountChange(this.getTunerChannelCount()));
            if (this.mPolyphaseChannelizer.getRegisteredChannelCount() == 0) {
                this.mNativeBufferProvider.removeBufferListener(this.mBufferDispatcher);
                this.mBufferDispatcher.stop();
                this.mPolyphaseChannelizer.stop();
            }
        }
        try {
            channelSource.process(SourceEvent.stopSampleStreamNotification(channelSource));
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    @Override
    public void process(SourceEvent sourceEvent) throws SourceException {
        switch (sourceEvent.getEvent()) {
            case NOTIFICATION_FREQUENCY_CHANGE: {
                this.mNativeBufferReceiver.receive(sourceEvent);
                break;
            }
            case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                double sampleRate = sourceEvent.getValue().doubleValue();
                int channelCount = ComplexPolyphaseChannelizerM2.getChannelCount(sampleRate);
                this.mChannelCalculator.setRates(sampleRate, channelCount);
                break;
            }
            case NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_LOCKED: 
            case NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_UNLOCKED: 
            case NOTIFICATION_FREQUENCY_CORRECTION_CHANGE: 
            case NOTIFICATION_RECORDING_FILE_LOADED: {
                break;
            }
            default: {
                mLog.info("Unrecognized source event: " + String.valueOf(sourceEvent));
            }
        }
    }

    private void checkChannelizerConfiguration() {
        double tunerSampleRate = this.mChannelCalculator.getSampleRate();
        if (this.mPolyphaseChannelizer == null || FastMath.abs((double)(this.mPolyphaseChannelizer.getSampleRate() - tunerSampleRate)) > 0.5) {
            if (this.mPolyphaseChannelizer != null && this.mPolyphaseChannelizer.getRegisteredChannelCount() > 0) {
                throw new IllegalStateException("Polyphase Channelizer cannot be changed to a new sample rate while channels are currently sourced.  Ensure you remove all tuner channels before changing tuner sample rate.  Current channel count:" + String.valueOf(this.mPolyphaseChannelizer != null ? Integer.valueOf(this.mPolyphaseChannelizer.getRegisteredChannelCount()) : "0"));
            }
            try {
                this.mPolyphaseChannelizer = new ComplexPolyphaseChannelizerM2(tunerSampleRate, 9);
            }
            catch (IllegalArgumentException iae) {
                mLog.error("Could not create polyphase channelizer for sample rate [" + tunerSampleRate + "]", (Throwable)iae);
            }
            catch (FilterDesignException fde) {
                mLog.error("Could not create filter for polyphase channelizer for sample rate [" + tunerSampleRate + "]", (Throwable)fde);
            }
            this.mOutputProcessorFilters.clear();
        }
    }

    private void updateOutputProcessors() {
        for (PolyphaseChannelSource channelSource : this.mChannelSources) {
            try {
                channelSource.updateOutputProcessor(this.mChannelCalculator, this.mFilterManager);
            }
            catch (IllegalArgumentException iae) {
                mLog.error("Error updating polyphase channel source output processor following tuner frequency or sample rate change");
                this.stopChannelSource(channelSource);
            }
        }
    }

    public SortedSet<TunerChannel> getTunerChannels() {
        TreeSet<TunerChannel> tunerChannels = new TreeSet<TunerChannel>();
        for (PolyphaseChannelSource channelSource : this.mChannelSources) {
            tunerChannels.add(channelSource.getTunerChannel());
        }
        return tunerChannels;
    }

    public int getTunerChannelCount() {
        return this.mChannelSources.size();
    }

    public void addSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventBroadcaster.addListener(listener);
    }

    public void removeSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventBroadcaster.removeListener(listener);
    }

    private class ChannelSourceEventListener
    implements Listener<SourceEvent> {
        private ChannelSourceEventListener() {
        }

        @Override
        public void receive(SourceEvent sourceEvent) {
            switch (sourceEvent.getEvent()) {
                case REQUEST_START_SAMPLE_STREAM: {
                    if (sourceEvent.hasSource() && sourceEvent.getSource() instanceof PolyphaseChannelSource) {
                        PolyphaseChannelManager.this.startChannelSource((PolyphaseChannelSource)sourceEvent.getSource());
                        break;
                    }
                    mLog.error("Request to start sample stream for unrecognized source: " + String.valueOf(sourceEvent.hasSource() ? sourceEvent.getSource().getClass() : "null source"));
                    break;
                }
                case REQUEST_STOP_SAMPLE_STREAM: {
                    Source source;
                    if (sourceEvent.hasSource() && (source = sourceEvent.getSource()) instanceof PolyphaseChannelSource) {
                        PolyphaseChannelSource channelSource = (PolyphaseChannelSource)source;
                        PolyphaseChannelManager.this.stopChannelSource(channelSource);
                        channelSource.dispose();
                        break;
                    }
                    mLog.error("Request to stop sample stream for unrecognized source: " + String.valueOf(sourceEvent.hasSource() ? sourceEvent.getSource().getClass() : "null source"));
                    break;
                }
                case NOTIFICATION_MEASURED_FREQUENCY_ERROR_SYNC_LOCKED: {
                    PolyphaseChannelManager.this.mSourceEventBroadcaster.broadcast(sourceEvent);
                    break;
                }
                default: {
                    mLog.error("Received unrecognized source event from polyphase channel source [" + String.valueOf((Object)sourceEvent.getEvent()) + "]");
                }
            }
        }
    }

    public class NativeBufferReceiver
    implements Listener<INativeBuffer> {
        private boolean mOutputProcessorUpdateRequired = false;

        @Override
        public void receive(SourceEvent event) {
            long frequency = event.getValue().longValue();
            if (PolyphaseChannelManager.this.mChannelCalculator.getCenterFrequency() != (double)frequency) {
                PolyphaseChannelManager.this.mChannelCalculator.setCenterFrequency(frequency);
                this.mOutputProcessorUpdateRequired = true;
            }
        }

        @Override
        public void receive(INativeBuffer nativeBuffer) {
            if (this.mOutputProcessorUpdateRequired) {
                try {
                    PolyphaseChannelManager.this.updateOutputProcessors();
                }
                catch (Exception e) {
                    mLog.error("Error updating polyphase channel output processors");
                }
                this.mOutputProcessorUpdateRequired = false;
            }
            if (PolyphaseChannelManager.this.mPolyphaseChannelizer != null) {
                Iterator<InterleavedComplexSamples> iterator = nativeBuffer.iteratorInterleaved();
                while (iterator.hasNext()) {
                    try {
                        PolyphaseChannelManager.this.mPolyphaseChannelizer.receive(iterator.next());
                    }
                    catch (Throwable throwable) {
                        mLog.error("Error", throwable);
                    }
                }
            }
        }
    }
}

