/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.channelizer.AbstractComplexPolyphaseChannelizer;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import io.github.dsheirer.util.Dispatcher;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.fft.FloatFFT_1D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexPolyphaseChannelizerM2
extends AbstractComplexPolyphaseChannelizer {
    private static final Logger mLog = LoggerFactory.getLogger(ComplexPolyphaseChannelizerM2.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
    private static final int DEFAULT_MINIMUM_CHANNEL_BANDWIDTH = 25000;
    private static final int PROCESSED_CHANNEL_RESULTS_THRESHOLD = 1024;
    private IFFTProcessorDispatcher mIFFTProcessorDispatcher = new IFFTProcessorDispatcher(25L);
    private FloatFFT_1D mFFT;
    private float[] mInlineSamples;
    private float[] mInlineFilter;
    private boolean mTopBlockIndicator = true;
    private int[] mTopBlockMap;
    private int[] mMiddleBlockMap;
    private int mSampleBufferPointer;
    private int mSamplesPerBlock;
    private int mTapsPerChannel;
    private List<float[]> mProcessedChannelResultsList = new ArrayList<float[]>();

    public ComplexPolyphaseChannelizerM2(float[] taps, int sampleRate, int channelCount) {
        super(sampleRate, channelCount);
        if (channelCount % 2 != 0) {
            throw new IllegalArgumentException("Channel count must be an even multiple of the over-sample rate (2x)");
        }
        this.mTapsPerChannel = (int)FastMath.ceil((double)((double)taps.length / (double)channelCount));
        this.init(taps);
    }

    public ComplexPolyphaseChannelizerM2(double sampleRate, int tapsPerChannel) throws FilterDesignException {
        super(sampleRate, ComplexPolyphaseChannelizerM2.getChannelCount(sampleRate));
        this.mTapsPerChannel = tapsPerChannel;
        float[] filterTaps = FilterFactory.getSincM2Channelizer(this.getChannelSampleRate(), this.getChannelCount(), this.mTapsPerChannel, false);
        this.init(filterTaps);
    }

    public void start() {
        this.mIFFTProcessorDispatcher.start();
    }

    public void stop() {
        this.mIFFTProcessorDispatcher.stop();
    }

    public static int getChannelCount(double sampleRate) {
        int channels = (int)(sampleRate / 25000.0);
        if (channels % 2 != 0) {
            --channels;
        }
        mLog.info("Sample Rate [" + DECIMAL_FORMAT.format(sampleRate) + "] providing [" + channels + "] channels at [" + DECIMAL_FORMAT.format(sampleRate / (double)channels) + "] Hz each");
        return channels;
    }

    @Override
    public void setRates(double sampleRate, int channelCount) {
        try {
            super.setRates(sampleRate, channelCount);
            float[] filterTaps = FilterFactory.getSincM2Channelizer(this.getChannelSampleRate(), this.getChannelCount(), this.mTapsPerChannel, false);
            this.init(filterTaps);
        }
        catch (FilterDesignException fde) {
            throw new IllegalArgumentException("Cannot create a channelizer filter for the specified sample rate [" + sampleRate + "]");
        }
    }

    @Override
    public void receive(InterleavedComplexSamples complexSamples) {
        this.mCurrentSamplesTimestamp = complexSamples.timestamp();
        float[] samples = complexSamples.samples();
        int samplesPointer = 0;
        while (samplesPointer < samples.length) {
            if (this.mSampleBufferPointer < this.mSamplesPerBlock) {
                int samplesDiff = samples.length - samplesPointer;
                int samplesToCopy = this.mSamplesPerBlock - this.mSampleBufferPointer;
                if (samplesDiff < samplesToCopy) {
                    samplesToCopy = samplesDiff;
                }
                System.arraycopy(samples, samplesPointer, this.mInlineSamples, this.mSampleBufferPointer, samplesToCopy);
                this.mSampleBufferPointer += samplesToCopy;
                samplesPointer += samplesToCopy;
            }
            if (this.mSampleBufferPointer < this.mSamplesPerBlock) continue;
            this.mProcessedChannelResultsList.add(this.process());
            if (this.mProcessedChannelResultsList.size() >= 1024) {
                this.mIFFTProcessorDispatcher.receive(new ArrayList<float[]>(this.mProcessedChannelResultsList));
                this.mProcessedChannelResultsList.clear();
            }
            System.arraycopy(this.mInlineSamples, 0, this.mInlineSamples, this.mSamplesPerBlock, this.mInlineSamples.length - this.mSamplesPerBlock);
            this.mSampleBufferPointer = 0;
        }
    }

    private static int[] getTopBlockMap(int channelCount) {
        int[] newMap = new int[channelCount * 2];
        int blockSize = channelCount / 2;
        for (int channel = 0; channel < blockSize; ++channel) {
            int newIndex = 2 * channel;
            int originalIndex = 2 * (blockSize - channel - 1);
            int offset = 2 * blockSize;
            newMap[originalIndex] = newIndex;
            newMap[originalIndex + 1] = newIndex + 1;
            newMap[offset + originalIndex] = offset + newIndex;
            newMap[offset + originalIndex + 1] = offset + newIndex + 1;
        }
        return newMap;
    }

    private static int[] getMiddleBlockMap(int channelCount) {
        int[] newMap = new int[channelCount * 2];
        int blockSize = channelCount / 2;
        for (int channel = 0; channel < blockSize; ++channel) {
            int newIndex = 2 * channel;
            int originalIndex = 2 * (blockSize - channel - 1);
            int offset = 2 * blockSize;
            newMap[offset + originalIndex] = newIndex;
            newMap[offset + originalIndex + 1] = newIndex + 1;
            newMap[originalIndex] = offset + newIndex;
            newMap[originalIndex + 1] = offset + newIndex + 1;
        }
        return newMap;
    }

    private static float[] getAlignedFilter(float[] coefficients, int channelCount, int tapsPerChannel) {
        float[] filter = new float[channelCount * tapsPerChannel * 2];
        int blockSize = channelCount;
        int coefficientPointer = 0;
        int filterPointer = 0;
        while (coefficientPointer < coefficients.length) {
            filter[filterPointer++] = coefficients[coefficientPointer];
            filter[filterPointer++] = coefficients[coefficientPointer++];
        }
        for (int x = 0; x < filter.length; x += blockSize) {
            for (int y = 0; y < blockSize / 2; ++y) {
                int index1 = x + y;
                int index2 = x + (blockSize - y - 1);
                float temp = filter[index2];
                filter[index2] = filter[index1];
                filter[index1] = temp;
            }
        }
        return filter;
    }

    private float[] process() {
        int bufferLength = this.getSubChannelCount() * this.mTapsPerChannel;
        float[] inlineInterimOutput = new float[bufferLength];
        for (int x = 0; x < this.mInlineSamples.length; ++x) {
            inlineInterimOutput[x] = this.mInlineSamples[x] * this.mInlineFilter[x];
        }
        float[] filterAccumulator = new float[this.getSubChannelCount()];
        int tapOffset = 0;
        for (int tap = 0; tap < this.mTapsPerChannel; ++tap) {
            tapOffset = tap * this.getSubChannelCount();
            for (int channel = 0; channel < this.getSubChannelCount(); ++channel) {
                int n = channel;
                filterAccumulator[n] = filterAccumulator[n] + inlineInterimOutput[tapOffset + channel];
            }
        }
        float[] processed = new float[this.getSubChannelCount()];
        if (this.mTopBlockIndicator) {
            for (x = 0; x < this.getSubChannelCount(); ++x) {
                processed[x] = filterAccumulator[this.mTopBlockMap[x]];
            }
        } else {
            for (x = 0; x < this.getSubChannelCount(); ++x) {
                processed[x] = filterAccumulator[this.mMiddleBlockMap[x]];
            }
        }
        this.mTopBlockIndicator = !this.mTopBlockIndicator;
        return processed;
    }

    private void init(float[] coefficients) {
        int channelCount = this.getChannelCount();
        this.mFFT = new FloatFFT_1D((long)channelCount);
        int bufferLength = this.getSubChannelCount() * this.mTapsPerChannel;
        this.mSamplesPerBlock = channelCount;
        this.mTopBlockMap = ComplexPolyphaseChannelizerM2.getTopBlockMap(channelCount);
        this.mMiddleBlockMap = ComplexPolyphaseChannelizerM2.getMiddleBlockMap(channelCount);
        this.mInlineFilter = ComplexPolyphaseChannelizerM2.getAlignedFilter(coefficients, channelCount, this.mTapsPerChannel);
        this.mInlineSamples = new float[bufferLength];
    }

    public class IFFTProcessorDispatcher
    extends Dispatcher<List<float[]>> {
        public IFFTProcessorDispatcher(long interval) {
            super("sdrtrunk polyphase ifft processor", interval);
            this.setListener(list -> {
                try {
                    ArrayList<float[]> processedChannelResults = new ArrayList<float[]>();
                    for (float[] channelResults : list) {
                        if (channelResults == null) continue;
                        ComplexPolyphaseChannelizerM2.this.mFFT.complexInverse(channelResults, true);
                        processedChannelResults.add(channelResults);
                    }
                    ComplexPolyphaseChannelizerM2.this.dispatch(processedChannelResults);
                }
                catch (Throwable t) {
                    mLog.error("Error during IFFT and dispatch of processed channel results", t);
                }
            });
        }
    }
}

