/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer;

import io.github.dsheirer.dsp.filter.channelizer.PolyphaseChannelSource;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.SourceEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComplexPolyphaseChannelizer
implements Listener<InterleavedComplexSamples>,
ISourceEventListener {
    private static final Logger mLog = LoggerFactory.getLogger(AbstractComplexPolyphaseChannelizer.class);
    private Broadcaster<SourceEvent> mSourceChangeBroadcaster = new Broadcaster();
    private List<PolyphaseChannelSource> mChannels = new CopyOnWriteArrayList<PolyphaseChannelSource>();
    private double mSampleRate;
    private int mChannelCount;
    private int mSubChannelCount;
    private double mChannelSampleRate;
    protected long mCurrentSamplesTimestamp;

    public AbstractComplexPolyphaseChannelizer(double sampleRate, int channelCount) {
        this.mChannelCount = channelCount;
        this.mSubChannelCount = channelCount * 2;
        this.mSampleRate = sampleRate;
        this.mChannelSampleRate = this.mSampleRate / (double)this.mChannelCount;
    }

    public double getSampleRate() {
        return this.mSampleRate;
    }

    public void setRates(double sampleRate, int channelCount) {
        this.mSampleRate = sampleRate;
        this.mChannelCount = channelCount;
        this.mChannelSampleRate = this.mSampleRate / (double)this.mChannelCount;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getSubChannelCount() {
        return this.mSubChannelCount;
    }

    public double getChannelSampleRate() {
        return this.mChannelSampleRate;
    }

    protected void dispatch(List<float[]> channelResultsList) {
        for (PolyphaseChannelSource channel : this.mChannels) {
            channel.receiveChannelResults(channelResultsList, this.mCurrentSamplesTimestamp);
        }
    }

    public void addChannel(PolyphaseChannelSource polyphaseChannelSource) {
        if (polyphaseChannelSource != null && !this.mChannels.contains(polyphaseChannelSource)) {
            this.mChannels.add(polyphaseChannelSource);
            this.mSourceChangeBroadcaster.addListener(polyphaseChannelSource.getSourceEventListener());
        } else {
            mLog.error("Error adding polyphase channel source - " + (polyphaseChannelSource == null ? "source is null" : "channel source is already added to this channelizer"));
        }
    }

    public void removeChannel(PolyphaseChannelSource polyphaseChannelSource) {
        if (polyphaseChannelSource != null && this.mChannels.contains(polyphaseChannelSource)) {
            this.mChannels.remove(polyphaseChannelSource);
            this.mSourceChangeBroadcaster.removeListener(polyphaseChannelSource.getSourceEventListener());
        } else {
            mLog.error("Error removing polyphase channel source - " + (polyphaseChannelSource == null ? "source is null" : "channel source was not previously added to this channelizer"));
        }
    }

    public int getRegisteredChannelCount() {
        return this.mChannels.size();
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return this.mSourceChangeBroadcaster;
    }
}

