/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter;

import io.github.dsheirer.dsp.window.WindowFactory;
import io.github.dsheirer.dsp.window.WindowType;
import org.apache.commons.math3.util.FastMath;

public class GoertzelFilter {
    private int mSampleRate;
    private long mTargetFrequency;
    private int mBlockSize;
    private float[] mWindowCoefficients;
    private double mCoefficient;

    public GoertzelFilter(int sampleRate, long targetFrequency, int blockSize, WindowType window) {
        this.mSampleRate = sampleRate;
        this.mTargetFrequency = targetFrequency;
        this.mBlockSize = blockSize;
        this.mWindowCoefficients = WindowFactory.getWindow(window, blockSize);
        this.init();
    }

    private void init() {
        double normalizedFrequency = (double)this.mTargetFrequency / (double)this.mSampleRate;
        this.mCoefficient = 2.0 * FastMath.cos((double)(Math.PI * 2 * normalizedFrequency));
    }

    public int getPower(float[] samples) throws IllegalArgumentException {
        if (samples.length != this.mBlockSize) {
            throw new IllegalArgumentException("Sample array size does not equal Block Size");
        }
        samples = WindowFactory.apply(this.mWindowCoefficients, samples);
        double s = 0.0;
        double s_prev = 0.0;
        double s_prev2 = 0.0;
        for (float sample : samples) {
            s = (double)sample + this.mCoefficient * s_prev - s_prev2;
            s_prev2 = s_prev;
            s_prev = s;
        }
        double magnitude = s_prev2 * s_prev2 + s_prev * s_prev - this.mCoefficient * s_prev * s_prev2;
        int binZero = this.getBinZeroPower(samples);
        int power = (int)(20.0 * FastMath.log10((double)(magnitude / (double)binZero)));
        return power;
    }

    private int getBinZeroPower(float[] samples) {
        int retVal = 0;
        for (float sample : samples) {
            retVal = (int)((float)retVal + sample);
        }
        return retVal;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public long getTargetFrequency() {
        return this.mTargetFrequency;
    }

    public int getBlockSize() {
        return this.mBlockSize;
    }
}

