/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter;

import io.github.dsheirer.sample.real.RealSampleListener;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;

public class FloatFIRFilter
implements RealSampleListener {
    private RealSampleListener mListener;
    private ArrayList<Float> mBuffer;
    private int mBufferSize = 1;
    private int mBufferPointer = 0;
    private float[] mCoefficients;
    private int[][] mIndexMap;
    private int mCenterCoefficient;
    private int mCenterCoefficientMapIndex;
    private float mGain;

    public FloatFIRFilter(float[] coefficients, float gain) {
        this.mCoefficients = coefficients;
        this.mBuffer = new ArrayList();
        this.mBufferSize = this.mCoefficients.length;
        this.mGain = gain;
        for (int x = 0; x < this.mCoefficients.length; ++x) {
            this.mBuffer.add(Float.valueOf(0.0f));
        }
        this.generateIndexMap(this.mCoefficients.length);
    }

    public void dispose() {
        this.mListener = null;
        this.mBuffer.clear();
    }

    public int getTapCount() {
        return this.mCoefficients.length;
    }

    public void setListener(RealSampleListener listener) {
        this.mListener = listener;
    }

    @Override
    public void receive(float newSample) {
        this.send(this.get(newSample));
    }

    public float get(float newSample) {
        this.mBuffer.set(this.mBufferPointer, Float.valueOf(newSample));
        ++this.mBufferPointer;
        if (this.mBufferPointer >= this.mBufferSize) {
            this.mBufferPointer = 0;
        }
        float accumulator = 0.0f;
        accumulator += this.mCoefficients[this.mCenterCoefficient] * this.mBuffer.get(this.mIndexMap[this.mBufferPointer][this.mCenterCoefficientMapIndex]).floatValue();
        for (int x = 0; x < this.mCenterCoefficient; ++x) {
            accumulator += this.mCoefficients[x] * (this.mBuffer.get(this.mIndexMap[this.mBufferPointer][x]).floatValue() + this.mBuffer.get(this.mIndexMap[this.mBufferPointer][x + this.mCenterCoefficient]).floatValue());
        }
        return accumulator * this.mGain;
    }

    private void send(float sample) {
        if (this.mListener != null) {
            this.mListener.receive(sample);
        }
    }

    public String printIndexMap() {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < this.mCoefficients.length; ++x) {
            for (int y = 0; y < this.mCoefficients.length; ++y) {
                sb.append(this.mIndexMap[x][y]).append("  ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void generateIndexMap(int size) {
        int x;
        Validate.isTrue((size % 2 == 1 ? 1 : 0) != 0);
        this.mIndexMap = new int[size][size];
        this.mCenterCoefficientMapIndex = size - 1;
        this.mIndexMap[0][this.mCenterCoefficient] = this.mCenterCoefficient = size / 2;
        for (x = 0; x < this.mCenterCoefficient; ++x) {
            this.mIndexMap[0][x] = x;
            this.mIndexMap[0][x + this.mCenterCoefficient] = size - 1 - x;
        }
        for (x = 1; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                this.mIndexMap[x][y] = this.mIndexMap[x - 1][y] + 1;
                if (this.mIndexMap[x][y] < size) continue;
                this.mIndexMap[x][y] = 0;
            }
        }
    }
}

