/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter;

import io.github.dsheirer.sample.Listener;
import java.util.BitSet;

public class BooleanAveragingFilter
implements Listener<Boolean> {
    private BitSet mBuffer = new BitSet();
    private int mBufferPointer;
    private int mBufferLength;
    private int mThreshold;
    private Listener<Boolean> mListener;

    public BooleanAveragingFilter(int length) {
        this.mBufferLength = length;
        this.mThreshold = length / 2 + length % 2;
    }

    @Override
    public void receive(Boolean value) {
        if (value.booleanValue()) {
            this.mBuffer.set(this.mBufferPointer);
        } else {
            this.mBuffer.clear(this.mBufferPointer);
        }
        ++this.mBufferPointer;
        if (this.mBufferPointer >= this.mBufferLength) {
            this.mBufferPointer = 0;
        }
        if (this.mListener != null) {
            this.mListener.receive(this.mBuffer.cardinality() >= this.mThreshold);
        }
    }

    public void setListener(Listener<Boolean> listener) {
        this.mListener = listener;
    }

    public void removeListener(Listener<Boolean> listener) {
        this.mListener = null;
    }
}

