/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.am;

import io.github.dsheirer.dsp.am.IAmDemodulator;
import io.github.dsheirer.dsp.magnitude.IMagnitudeCalculator;
import io.github.dsheirer.dsp.magnitude.MagnitudeFactory;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;
import org.apache.commons.math3.util.FastMath;

public class VectorAMDemodulator64
implements IAmDemodulator {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_64;
    private float mGain;
    private IMagnitudeCalculator mMagnitudeCalculator = MagnitudeFactory.getMagnitudeCalculator();

    public VectorAMDemodulator64(float gain) {
        this.mGain = gain;
    }

    public void setGain(float gain) {
        this.mGain = gain;
    }

    public float demodulate(float inphase, float quadrature) {
        return (float)FastMath.sqrt((double)(inphase * inphase + quadrature * quadrature)) * this.mGain;
    }

    @Override
    public float[] demodulateMagnitude(float[] magnitude) {
        VectorUtilities.checkArrayLength(magnitude, VECTOR_SPECIES);
        FloatVector gain = FloatVector.broadcast(VECTOR_SPECIES, (float)this.mGain);
        float[] demodulated = new float[magnitude.length];
        for (int x = 0; x < magnitude.length; x += VECTOR_SPECIES.length()) {
            FloatVector vector = FloatVector.fromArray(VECTOR_SPECIES, (float[])magnitude, (int)x);
            vector.sqrt().mul((Vector)gain).intoArray(demodulated, x);
        }
        return demodulated;
    }
}

