/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.am;

import io.github.dsheirer.dsp.am.AmDemodulatorFactory;
import io.github.dsheirer.dsp.am.IAmDemodulator;
import io.github.dsheirer.dsp.fm.ISquelchingDemodulator;
import io.github.dsheirer.dsp.magnitude.IMagnitudeCalculator;
import io.github.dsheirer.dsp.magnitude.MagnitudeFactory;
import io.github.dsheirer.dsp.squelch.AdaptiveSquelch;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceEvent;

public class SquelchingAMDemodulator
implements ISquelchingDemodulator,
Listener<SourceEvent> {
    private static final float ZERO = 0.0f;
    private final IMagnitudeCalculator mMagnitudeCalculator = MagnitudeFactory.getMagnitudeCalculator();
    private final IAmDemodulator mAmDemodulator;
    private final AdaptiveSquelch mAdaptiveSquelch;
    private boolean mSquelchChanged = false;

    public SquelchingAMDemodulator(float gain, float alpha, float squelchThreshold, boolean squelchAutoTrack) {
        this.mAmDemodulator = AmDemodulatorFactory.getAmDemodulator(gain);
        this.mAdaptiveSquelch = new AdaptiveSquelch(alpha, squelchThreshold, squelchAutoTrack);
    }

    @Override
    public void setSampleRate(int sampleRate) {
        this.mAdaptiveSquelch.setSampleRate(sampleRate);
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mAdaptiveSquelch.setSourceEventListener(listener);
    }

    @Override
    public float[] demodulate(float[] i, float[] q) {
        this.mAdaptiveSquelch.setSquelchChanged(false);
        this.setSquelchChanged(false);
        float[] magnitude = this.mMagnitudeCalculator.calculate(i, q);
        float[] demodulated = this.mAmDemodulator.demodulateMagnitude(magnitude);
        for (int x = 0; x < i.length; ++x) {
            this.mAdaptiveSquelch.process(magnitude[x]);
            if (!this.mAdaptiveSquelch.isUnmuted()) {
                demodulated[x] = 0.0f;
            }
            if (!this.mAdaptiveSquelch.isSquelchChanged()) continue;
            this.setSquelchChanged(true);
        }
        return demodulated;
    }

    @Override
    public void setSquelchThreshold(float threshold) {
        this.mAdaptiveSquelch.setSquelchThreshold(threshold);
    }

    @Override
    public void setSquelchAutoTrack(boolean autoTrack) {
        this.mAdaptiveSquelch.setSquelchAutoTrack(autoTrack);
    }

    @Override
    public boolean isSquelchChanged() {
        return this.mSquelchChanged;
    }

    private void setSquelchChanged(boolean changed) {
        this.mSquelchChanged = changed;
    }

    @Override
    public boolean isMuted() {
        return this.mAdaptiveSquelch.isMuted();
    }

    @Override
    public void receive(SourceEvent sourceEvent) {
        switch (sourceEvent.getEvent()) {
            case REQUEST_CURRENT_SQUELCH_THRESHOLD: 
            case REQUEST_CHANGE_SQUELCH_THRESHOLD: 
            case REQUEST_CURRENT_SQUELCH_AUTO_TRACK: 
            case REQUEST_CHANGE_SQUELCH_AUTO_TRACK: {
                this.mAdaptiveSquelch.receive(sourceEvent);
            }
        }
    }
}

