/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.am;

import io.github.dsheirer.dsp.am.IAmDemodulator;
import org.apache.commons.math3.util.FastMath;

public class ScalarAMDemodulator
implements IAmDemodulator {
    private float mGain;

    public ScalarAMDemodulator(float gain) {
        this.mGain = gain;
    }

    public void setGain(float gain) {
        this.mGain = gain;
    }

    public float demodulate(float inphase, float quadrature) {
        return (float)FastMath.sqrt((double)(inphase * inphase + quadrature * quadrature)) * this.mGain;
    }

    @Override
    public float[] demodulateMagnitude(float[] magnitude) {
        float[] demodulated = new float[magnitude.length];
        for (int x = 0; x < magnitude.length; ++x) {
            demodulated[x] = (float)FastMath.sqrt((double)magnitude[x]) * this.mGain;
        }
        return demodulated;
    }
}

