/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.am;

import io.github.dsheirer.dsp.am.IAmDemodulator;
import io.github.dsheirer.dsp.am.ScalarAMDemodulator;
import io.github.dsheirer.dsp.am.VectorAMDemodulator128;
import io.github.dsheirer.dsp.am.VectorAMDemodulator256;
import io.github.dsheirer.dsp.am.VectorAMDemodulator512;
import io.github.dsheirer.dsp.am.VectorAMDemodulator64;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmDemodulatorFactory {
    private static final Logger mLog = LoggerFactory.getLogger(AmDemodulatorFactory.class);

    public static IAmDemodulator getAmDemodulator(float gain) {
        Implementation implementation = CalibrationManager.getInstance().getImplementation(CalibrationType.AM_DEMODULATOR);
        switch (implementation) {
            case VECTOR_SIMD_64: {
                return new VectorAMDemodulator64(gain);
            }
            case VECTOR_SIMD_128: {
                return new VectorAMDemodulator128(gain);
            }
            case VECTOR_SIMD_256: {
                return new VectorAMDemodulator256(gain);
            }
            case VECTOR_SIMD_512: {
                return new VectorAMDemodulator512(gain);
            }
            case VECTOR_SIMD_PREFERRED: {
                return new VectorAMDemodulator64(gain);
            }
            case SCALAR: 
            case UNCALIBRATED: {
                return new ScalarAMDemodulator(gain);
            }
        }
        mLog.warn("Unrecognized optimal operation for AM demodulator: " + implementation.name());
        return new ScalarAMDemodulator(gain);
    }
}

