/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.afsk;

public class AFSKTimingErrorDetector {
    protected boolean[] mBuffer;
    protected int mDetectedZeroCrossing;
    protected float mSymbolMiddle;
    private int mZeroCrossingCount;

    public AFSKTimingErrorDetector(int samplesPerSymbol) {
        this.mBuffer = new boolean[samplesPerSymbol];
        this.mSymbolMiddle = (float)(samplesPerSymbol - 1) / 2.0f;
    }

    public void receive(boolean sample) {
        System.arraycopy(this.mBuffer, 1, this.mBuffer, 0, this.mBuffer.length - 1);
        this.mBuffer[this.mBuffer.length - 1] = sample;
    }

    public int getError() {
        this.mZeroCrossingCount = 0;
        for (int x = 0; x < this.mBuffer.length - 1; ++x) {
            if (!(this.mBuffer[x] ^ this.mBuffer[x + 1])) continue;
            this.mDetectedZeroCrossing = x + 1;
            ++this.mZeroCrossingCount;
            if (this.mZeroCrossingCount <= 1) continue;
            return 0;
        }
        if (this.mZeroCrossingCount == 1) {
            if ((float)this.mDetectedZeroCrossing > this.mSymbolMiddle) {
                return -(this.mBuffer.length - this.mDetectedZeroCrossing);
            }
            return this.mDetectedZeroCrossing + 1;
        }
        return 0;
    }
}

