/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.afsk;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AFSKSampleBuffer {
    private static final Logger mLog = LoggerFactory.getLogger(AFSKSampleBuffer.class);
    private static final float SYMBOL_SAMPLE_THRESHOLD = 1.0f;
    protected boolean[] mDelayLine;
    protected int mDelayLinePointer = 0;
    private int mHalfIntegerSamplesPerSymbol;
    private int mPositiveSampleDecisionCount;
    protected int mTwiceSamplesPerSymbol;
    protected int mSymbolStart;
    protected int mSymbolEnd;
    protected int mSamplesPerSymbol;
    protected float mSymbolSamplingPoint;
    protected float mSymbolTimingGain;

    public AFSKSampleBuffer(int samplesPerSymbol, float symbolTimingGain) {
        this.mSamplesPerSymbol = samplesPerSymbol;
        this.mSymbolTimingGain = symbolTimingGain;
        this.mHalfIntegerSamplesPerSymbol = samplesPerSymbol / 2;
        this.mSymbolSamplingPoint = samplesPerSymbol;
        this.mTwiceSamplesPerSymbol = 2 * samplesPerSymbol;
        this.mDelayLine = new boolean[2 * this.mTwiceSamplesPerSymbol];
    }

    public void receive(boolean sample) {
        this.mSymbolSamplingPoint -= 1.0f;
        this.mDelayLine[this.mDelayLinePointer] = sample;
        this.mDelayLine[this.mDelayLinePointer + this.mTwiceSamplesPerSymbol] = sample;
        ++this.mDelayLinePointer;
        this.mDelayLinePointer %= this.mTwiceSamplesPerSymbol;
    }

    public void resetAndAdjust(float symbolTimingError) {
        this.mSymbolSamplingPoint += (float)this.mSamplesPerSymbol + symbolTimingError * this.mSymbolTimingGain;
    }

    public void setTimingGain(float gain) {
        this.mSymbolTimingGain = gain;
    }

    public boolean hasSymbol() {
        return this.mSymbolSamplingPoint < 1.0f;
    }

    public boolean getSymbol() {
        this.mPositiveSampleDecisionCount = 0;
        this.mSymbolStart = this.mDelayLinePointer;
        this.mSymbolEnd = this.mDelayLinePointer + this.mSamplesPerSymbol - 1;
        for (int x = this.mSymbolStart; x <= this.mSymbolEnd; ++x) {
            if (!this.mDelayLine[x]) continue;
            ++this.mPositiveSampleDecisionCount;
        }
        return this.mPositiveSampleDecisionCount > this.mHalfIntegerSamplesPerSymbol;
    }
}

