/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel.map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.text.DecimalFormat;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.util.Callback;

@JacksonXmlRootElement(localName="range")
public class ChannelRange {
    private static final DecimalFormat FREQUENCY_FORMATTER = new DecimalFormat("#.0000");
    private IntegerProperty mFirstChannel = new SimpleIntegerProperty(1);
    private IntegerProperty mLastChannel = new SimpleIntegerProperty(1023);
    private IntegerProperty mBaseFrequency = new SimpleIntegerProperty(450000000);
    private IntegerProperty mStepSize = new SimpleIntegerProperty(12500);
    private BooleanProperty mValid = new SimpleBooleanProperty();
    private BooleanProperty mOverlapping = new SimpleBooleanProperty();

    public ChannelRange() {
        this.mValid.bind((ObservableValue)Bindings.lessThan((ObservableNumberValue)this.mFirstChannel, (ObservableNumberValue)this.mLastChannel));
    }

    public ChannelRange(int first, int last, int base, int sizeProperty) {
        this();
        this.mFirstChannel.set(first);
        this.mLastChannel.set(last);
        this.mBaseFrequency.set(base);
        this.mStepSize.set(sizeProperty);
    }

    public ChannelRange copyOf() {
        return new ChannelRange(this.mFirstChannel.get(), this.mLastChannel.get(), this.mBaseFrequency.get(), this.mStepSize.get());
    }

    public BooleanProperty overlappingProperty() {
        return this.mOverlapping;
    }

    public BooleanProperty validProperty() {
        return this.mValid;
    }

    public IntegerProperty firstChannelProperty() {
        return this.mFirstChannel;
    }

    public IntegerProperty lastChannelProperty() {
        return this.mLastChannel;
    }

    public IntegerProperty baseFrequencyProperty() {
        return this.mBaseFrequency;
    }

    public IntegerProperty stepSizeProperty() {
        return this.mStepSize;
    }

    @JsonIgnore
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.isValid()) {
            sb.append("First: ");
            sb.append(this.mFirstChannel.get()).append("=");
            long frequency = this.getFrequency(this.mFirstChannel.get());
            sb.append(FREQUENCY_FORMATTER.format((double)frequency / 1000000.0));
            sb.append("  Last: ");
            sb.append(this.mLastChannel.get()).append("=");
            frequency = this.getFrequency(this.mLastChannel.get());
            sb.append(FREQUENCY_FORMATTER.format((double)frequency / 1000000.0));
            sb.append(" MHz");
        } else {
            sb.append("First channel must be smaller than last channel");
        }
        if (this.isOverlapping()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Overlap!");
        }
        return sb.toString();
    }

    @JsonIgnore
    public boolean isValid() {
        return this.mValid.get();
    }

    public boolean overlaps(ChannelRange other) {
        return this.mFirstChannel.get() <= other.mFirstChannel.get() && other.mFirstChannel.get() <= this.mLastChannel.get() || this.mFirstChannel.get() <= other.mLastChannel.get() && other.mLastChannel.get() <= this.mLastChannel.get() || this.mFirstChannel.get() <= other.mFirstChannel.get() && other.mLastChannel.get() <= this.mLastChannel.get() || other.mFirstChannel.get() <= this.mFirstChannel.get() && this.mLastChannel.get() <= other.mLastChannel.get();
    }

    @JsonIgnore
    public boolean isOverlapping() {
        return this.mOverlapping.get();
    }

    public void setOverlapping(boolean overlapping) {
        this.mOverlapping.set(overlapping);
    }

    public boolean hasChannel(int channel) {
        return this.mFirstChannel.get() <= channel && channel <= this.mLastChannel.get();
    }

    public long getFrequency(int channel) {
        if (this.hasChannel(channel)) {
            return this.mBaseFrequency.get() + (channel - this.mFirstChannel.get()) * this.mStepSize.get();
        }
        return 0L;
    }

    @JacksonXmlProperty(isAttribute=true, localName="first")
    public int getFirstChannelNumber() {
        return this.mFirstChannel.get();
    }

    public void setFirstChannelNumber(int first) {
        this.mFirstChannel.set(first);
    }

    @JacksonXmlProperty(isAttribute=true, localName="last")
    public void setLastChannelNumber(int last) {
        this.mLastChannel.set(last);
    }

    public int getLastChannelNumber() {
        return this.mLastChannel.get();
    }

    @JacksonXmlProperty(isAttribute=true, localName="base")
    public void setBaseFrequency(int baseFrequency) {
        this.mBaseFrequency.set(baseFrequency);
    }

    public int getBaseFrequency() {
        return this.mBaseFrequency.get();
    }

    @JacksonXmlProperty(isAttribute=true, localName="size")
    public void setStepSize(int stepSize) {
        this.mStepSize.set(stepSize);
    }

    public int getStepSize() {
        return this.mStepSize.get();
    }

    /*
     * Exception decompiling
     */
    public static Callback<ChannelRange, Observable[]> extractor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

