/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.ChannelModel;
import io.github.dsheirer.sample.Listener;

public class ChannelSelectionManager
implements Listener<ChannelEvent> {
    private Listener<ChannelEvent> mChannelEventListener;
    private Channel mSelectedChannel = null;

    public ChannelSelectionManager(ChannelModel channelModel) {
        this.mChannelEventListener = channelModel;
        channelModel.addListener(this);
    }

    @Override
    public void receive(ChannelEvent event) {
        switch (event.getEvent()) {
            case REQUEST_SELECT: {
                if (this.mSelectedChannel != null) {
                    this.mSelectedChannel.setSelected(false);
                    this.mChannelEventListener.receive(new ChannelEvent(this.mSelectedChannel, ChannelEvent.Event.NOTIFICATION_SELECTION_CHANGE));
                    this.mSelectedChannel = null;
                }
                this.mSelectedChannel = event.getChannel();
                this.mSelectedChannel.setSelected(true);
                this.mChannelEventListener.receive(new ChannelEvent(event.getChannel(), ChannelEvent.Event.NOTIFICATION_SELECTION_CHANGE));
                break;
            }
            case NOTIFICATION_PROCESSING_STOP: 
            case REQUEST_DESELECT: {
                if (this.mSelectedChannel == null || this.mSelectedChannel != event.getChannel()) break;
                this.mSelectedChannel.setSelected(false);
                this.mSelectedChannel = null;
                this.mChannelEventListener.receive(new ChannelEvent(event.getChannel(), ChannelEvent.Event.NOTIFICATION_SELECTION_CHANGE));
                break;
            }
        }
    }
}

